# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/ads/datamanager/v1/ingestion_service_pb"
require "google/ads/data_manager/v1/ingestion_service/rest"


class ::Google::Ads::DataManager::V1::IngestionService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_ingest_audience_members
    # Create test objects.
    client_result = ::Google::Ads::DataManager::V1::IngestAudienceMembersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    destinations = [{}]
    audience_members = [{}]
    consent = {}
    validate_only = true
    encoding = :ENCODING_UNSPECIFIED
    encryption_info = {}
    terms_of_service = {}

    ingest_audience_members_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Ads::DataManager::V1::IngestionService::Rest::ServiceStub.stub :transcode_ingest_audience_members_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, ingest_audience_members_client_stub do
        # Create client
        client = ::Google::Ads::DataManager::V1::IngestionService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.ingest_audience_members({ destinations: destinations, audience_members: audience_members, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info, terms_of_service: terms_of_service }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.ingest_audience_members destinations: destinations, audience_members: audience_members, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info, terms_of_service: terms_of_service do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.ingest_audience_members ::Google::Ads::DataManager::V1::IngestAudienceMembersRequest.new(destinations: destinations, audience_members: audience_members, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info, terms_of_service: terms_of_service) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.ingest_audience_members({ destinations: destinations, audience_members: audience_members, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info, terms_of_service: terms_of_service }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.ingest_audience_members(::Google::Ads::DataManager::V1::IngestAudienceMembersRequest.new(destinations: destinations, audience_members: audience_members, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info, terms_of_service: terms_of_service), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, ingest_audience_members_client_stub.call_count
      end
    end
  end

  def test_remove_audience_members
    # Create test objects.
    client_result = ::Google::Ads::DataManager::V1::RemoveAudienceMembersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    destinations = [{}]
    audience_members = [{}]
    validate_only = true
    encoding = :ENCODING_UNSPECIFIED
    encryption_info = {}

    remove_audience_members_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Ads::DataManager::V1::IngestionService::Rest::ServiceStub.stub :transcode_remove_audience_members_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_audience_members_client_stub do
        # Create client
        client = ::Google::Ads::DataManager::V1::IngestionService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_audience_members({ destinations: destinations, audience_members: audience_members, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_audience_members destinations: destinations, audience_members: audience_members, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_audience_members ::Google::Ads::DataManager::V1::RemoveAudienceMembersRequest.new(destinations: destinations, audience_members: audience_members, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_audience_members({ destinations: destinations, audience_members: audience_members, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_audience_members(::Google::Ads::DataManager::V1::RemoveAudienceMembersRequest.new(destinations: destinations, audience_members: audience_members, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_audience_members_client_stub.call_count
      end
    end
  end

  def test_ingest_events
    # Create test objects.
    client_result = ::Google::Ads::DataManager::V1::IngestEventsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    destinations = [{}]
    events = [{}]
    consent = {}
    validate_only = true
    encoding = :ENCODING_UNSPECIFIED
    encryption_info = {}

    ingest_events_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Ads::DataManager::V1::IngestionService::Rest::ServiceStub.stub :transcode_ingest_events_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, ingest_events_client_stub do
        # Create client
        client = ::Google::Ads::DataManager::V1::IngestionService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.ingest_events({ destinations: destinations, events: events, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.ingest_events destinations: destinations, events: events, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.ingest_events ::Google::Ads::DataManager::V1::IngestEventsRequest.new(destinations: destinations, events: events, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.ingest_events({ destinations: destinations, events: events, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.ingest_events(::Google::Ads::DataManager::V1::IngestEventsRequest.new(destinations: destinations, events: events, consent: consent, validate_only: validate_only, encoding: encoding, encryption_info: encryption_info), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, ingest_events_client_stub.call_count
      end
    end
  end

  def test_retrieve_request_status
    # Create test objects.
    client_result = ::Google::Ads::DataManager::V1::RetrieveRequestStatusResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    request_id = "hello world"

    retrieve_request_status_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Ads::DataManager::V1::IngestionService::Rest::ServiceStub.stub :transcode_retrieve_request_status_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, retrieve_request_status_client_stub do
        # Create client
        client = ::Google::Ads::DataManager::V1::IngestionService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.retrieve_request_status({ request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.retrieve_request_status request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.retrieve_request_status ::Google::Ads::DataManager::V1::RetrieveRequestStatusRequest.new(request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.retrieve_request_status({ request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.retrieve_request_status(::Google::Ads::DataManager::V1::RetrieveRequestStatusRequest.new(request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, retrieve_request_status_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Ads::DataManager::V1::IngestionService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Ads::DataManager::V1::IngestionService::Rest::Client::Configuration, config
  end
end
