# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module DataManager
      module V1
        # Advertiser-assessed information about the user at the time that the event
        # happened. See https://support.google.com/google-ads/answer/14007601 for more
        # details.
        # @!attribute [rw] customer_type
        #   @return [::Google::Ads::DataManager::V1::CustomerType]
        #     Optional. Type of the customer associated with the event.
        # @!attribute [rw] customer_value_bucket
        #   @return [::Google::Ads::DataManager::V1::CustomerValueBucket]
        #     Optional. The advertiser-assessed value of the customer.
        # @!attribute [rw] additional_user_properties
        #   @return [::Array<::Google::Ads::DataManager::V1::UserProperty>]
        #     Optional. A bucket of any additional [user
        #     properties](https://developers.google.com/analytics/devguides/collection/protocol/ga4/user-properties)
        #     for the user associated with this event.
        class UserProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A bucket of any additional [user
        # properties](https://developers.google.com/analytics/devguides/collection/protocol/ga4/user-properties)
        # for the user associated with this event.
        # @!attribute [rw] property_name
        #   @return [::String]
        #     Required. The name of the user property to use.
        # @!attribute [rw] value
        #   @return [::String]
        #     Required. The string representation of the value of the user property to
        #     use.
        class UserProperty
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Type of the customer associated with the event.
        module CustomerType
          # Unspecified CustomerType. Should never be used.
          CUSTOMER_TYPE_UNSPECIFIED = 0

          # The customer is new to the advertiser.
          NEW = 1

          # The customer is returning to the advertiser.
          RETURNING = 2

          # The customer has re-engaged with the advertiser.
          REENGAGED = 3
        end

        # The advertiser-assessed value of the customer.
        module CustomerValueBucket
          # Unspecified CustomerValueBucket. Should never be used.
          CUSTOMER_VALUE_BUCKET_UNSPECIFIED = 0

          # The customer is low value.
          LOW = 1

          # The customer is medium value.
          MEDIUM = 2

          # The customer is high value.
          HIGH = 3
        end
      end
    end
  end
end
