# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module DataManager
      module V1
        # Data that identifies the user. At least one identifier is required.
        # @!attribute [rw] user_identifiers
        #   @return [::Array<::Google::Ads::DataManager::V1::UserIdentifier>]
        #     Required. The identifiers for the user. It's possible to provide multiple
        #     instances of the same type of data (for example, multiple email addresses).
        #     To increase the likelihood of a match, provide as many identifiers as
        #     possible. At most 10 `userIdentifiers` can be provided in a single
        #     {::Google::Ads::DataManager::V1::AudienceMember AudienceMember} or
        #     {::Google::Ads::DataManager::V1::Event Event}.
        class UserData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A single identifier for the user.
        # @!attribute [rw] email_address
        #   @return [::String]
        #     Hashed email address using SHA-256 hash function after normalization.
        #
        #     Note: The following fields are mutually exclusive: `email_address`, `phone_number`, `address`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] phone_number
        #   @return [::String]
        #     Hashed phone number using SHA-256 hash function after normalization (E164
        #     standard).
        #
        #     Note: The following fields are mutually exclusive: `phone_number`, `email_address`, `address`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] address
        #   @return [::Google::Ads::DataManager::V1::AddressInfo]
        #     The known components of a user's address. Holds a grouping
        #     of identifiers that are matched all at once.
        #
        #     Note: The following fields are mutually exclusive: `address`, `email_address`, `phone_number`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class UserIdentifier
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Address information for the user.
        # @!attribute [rw] given_name
        #   @return [::String]
        #     Required. Given (first) name of the user, all lowercase, with no
        #     punctuation, no leading or trailing whitespace, and hashed as SHA-256.
        # @!attribute [rw] family_name
        #   @return [::String]
        #     Required. Family (last) name of the user, all lowercase, with no
        #     punctuation, no leading or trailing whitespace, and hashed as SHA-256.
        # @!attribute [rw] region_code
        #   @return [::String]
        #     Required. The 2-letter region code in ISO-3166-1 alpha-2 of the user's
        #     address.
        # @!attribute [rw] postal_code
        #   @return [::String]
        #     Required. The postal code of the user's address.
        class AddressInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
