# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module DataManager
      module V1
        # A request status per destination.
        # @!attribute [rw] destination
        #   @return [::Google::Ads::DataManager::V1::Destination]
        #     A destination within a DM API request.
        # @!attribute [rw] request_status
        #   @return [::Google::Ads::DataManager::V1::RequestStatusPerDestination::RequestStatus]
        #     The request status of the destination.
        # @!attribute [rw] error_info
        #   @return [::Google::Ads::DataManager::V1::ErrorInfo]
        #     An error info error containing the error reason and error counts related to
        #     the upload.
        # @!attribute [rw] warning_info
        #   @return [::Google::Ads::DataManager::V1::WarningInfo]
        #     A warning info containing the warning reason and warning counts related to
        #     the upload.
        # @!attribute [rw] audience_members_ingestion_status
        #   @return [::Google::Ads::DataManager::V1::RequestStatusPerDestination::IngestAudienceMembersStatus]
        #     The status of the ingest audience members request.
        #
        #     Note: The following fields are mutually exclusive: `audience_members_ingestion_status`, `events_ingestion_status`, `audience_members_removal_status`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] events_ingestion_status
        #   @return [::Google::Ads::DataManager::V1::RequestStatusPerDestination::IngestEventsStatus]
        #     The status of the ingest events request.
        #
        #     Note: The following fields are mutually exclusive: `events_ingestion_status`, `audience_members_ingestion_status`, `audience_members_removal_status`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] audience_members_removal_status
        #   @return [::Google::Ads::DataManager::V1::RequestStatusPerDestination::RemoveAudienceMembersStatus]
        #     The status of the remove audience members request.
        #
        #     Note: The following fields are mutually exclusive: `audience_members_removal_status`, `audience_members_ingestion_status`, `events_ingestion_status`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class RequestStatusPerDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The status of the ingest audience members request.
          # @!attribute [rw] user_data_ingestion_status
          #   @return [::Google::Ads::DataManager::V1::RequestStatusPerDestination::IngestUserDataStatus]
          #     The status of the user data ingestion to the destination.
          #
          #     Note: The following fields are mutually exclusive: `user_data_ingestion_status`, `mobile_data_ingestion_status`, `pair_data_ingestion_status`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] mobile_data_ingestion_status
          #   @return [::Google::Ads::DataManager::V1::RequestStatusPerDestination::IngestMobileDataStatus]
          #     The status of the mobile data ingestion to the destination.
          #
          #     Note: The following fields are mutually exclusive: `mobile_data_ingestion_status`, `user_data_ingestion_status`, `pair_data_ingestion_status`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] pair_data_ingestion_status
          #   @return [::Google::Ads::DataManager::V1::RequestStatusPerDestination::IngestPairDataStatus]
          #     The status of the pair data ingestion to the destination.
          #
          #     Note: The following fields are mutually exclusive: `pair_data_ingestion_status`, `user_data_ingestion_status`, `mobile_data_ingestion_status`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class IngestAudienceMembersStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The status of the remove audience members request.
          # @!attribute [rw] user_data_removal_status
          #   @return [::Google::Ads::DataManager::V1::RequestStatusPerDestination::RemoveUserDataStatus]
          #     The status of the user data removal from the destination.
          #
          #     Note: The following fields are mutually exclusive: `user_data_removal_status`, `mobile_data_removal_status`, `pair_data_removal_status`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] mobile_data_removal_status
          #   @return [::Google::Ads::DataManager::V1::RequestStatusPerDestination::RemoveMobileDataStatus]
          #     The status of the mobile data removal from the destination.
          #
          #     Note: The following fields are mutually exclusive: `mobile_data_removal_status`, `user_data_removal_status`, `pair_data_removal_status`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] pair_data_removal_status
          #   @return [::Google::Ads::DataManager::V1::RequestStatusPerDestination::RemovePairDataStatus]
          #     The status of the pair data removal from the destination.
          #
          #     Note: The following fields are mutually exclusive: `pair_data_removal_status`, `user_data_removal_status`, `mobile_data_removal_status`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class RemoveAudienceMembersStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The status of the events ingestion to the destination.
          # @!attribute [rw] record_count
          #   @return [::Integer]
          #     The total count of events sent in the upload request. Includes all
          #     events in the request, regardless of whether they were successfully
          #     ingested or not.
          class IngestEventsStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The status of the user data ingestion to the destination containing stats
          # related to the ingestion.
          # @!attribute [rw] record_count
          #   @return [::Integer]
          #     The total count of audience members sent in the upload request for the
          #     destination. Includes all audience members in the request, regardless of
          #     whether they were successfully ingested or not.
          # @!attribute [rw] user_identifier_count
          #   @return [::Integer]
          #     The total count of user identifiers sent in the upload request for the
          #     destination. Includes all user identifiers in the request, regardless of
          #     whether they were successfully ingested or not.
          # @!attribute [rw] upload_match_rate_range
          #   @return [::Google::Ads::DataManager::V1::MatchRateRange]
          #     The match rate range of the upload.
          class IngestUserDataStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The status of the user data removal from the destination.
          # @!attribute [rw] record_count
          #   @return [::Integer]
          #     The total count of audience members sent in the removal request. Includes
          #     all audience members in the request, regardless of whether they were
          #     successfully removed or not.
          # @!attribute [rw] user_identifier_count
          #   @return [::Integer]
          #     The total count of user identifiers sent in the removal request. Includes
          #     all user identifiers in the request, regardless of whether they were
          #     successfully removed or not.
          class RemoveUserDataStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The status of the mobile data ingestion to the destination containing stats
          # related to the ingestion.
          # @!attribute [rw] record_count
          #   @return [::Integer]
          #     The total count of audience members sent in the upload request for the
          #     destination. Includes all audience members in the request, regardless of
          #     whether they were successfully ingested or not.
          # @!attribute [rw] mobile_id_count
          #   @return [::Integer]
          #     The total count of mobile ids sent in the upload request for the
          #     destination. Includes all mobile ids in the request, regardless of
          #     whether they were successfully ingested or not.
          class IngestMobileDataStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The status of the mobile data removal from the destination.
          # @!attribute [rw] record_count
          #   @return [::Integer]
          #     The total count of audience members sent in the removal request. Includes
          #     all audience members in the request, regardless of whether they were
          #     successfully removed or not.
          # @!attribute [rw] mobile_id_count
          #   @return [::Integer]
          #     The total count of mobile Ids sent in the removal request. Includes all
          #     mobile ids in the request, regardless of whether they were successfully
          #     removed or not.
          class RemoveMobileDataStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The status of the pair data ingestion to the destination containing stats
          # related to the ingestion.
          # @!attribute [rw] record_count
          #   @return [::Integer]
          #     The total count of audience members sent in the upload request for the
          #     destination. Includes all audience members in the request, regardless of
          #     whether they were successfully ingested or not.
          # @!attribute [rw] pair_id_count
          #   @return [::Integer]
          #     The total count of pair ids sent in the upload request for the
          #     destination. Includes all pair ids in the request, regardless of
          #     whether they were successfully ingested or not.
          class IngestPairDataStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The status of the pair data removal from the destination.
          # @!attribute [rw] record_count
          #   @return [::Integer]
          #     The total count of audience members sent in the removal request. Includes
          #     all audience members in the request, regardless of whether they were
          #     successfully removed or not.
          # @!attribute [rw] pair_id_count
          #   @return [::Integer]
          #     The total count of pair ids sent in the removal request. Includes all
          #     pair ids in the request, regardless of whether they were successfully
          #     removed or not.
          class RemovePairDataStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request status.
          module RequestStatus
            # The request status is unknown.
            REQUEST_STATUS_UNKNOWN = 0

            # The request succeeded.
            SUCCESS = 1

            # The request is processing.
            PROCESSING = 2

            # The request failed.
            FAILED = 3

            # The request partially succeeded.
            PARTIAL_SUCCESS = 4
          end
        end
      end
    end
  end
end
