# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module DataManager
      module V1
        # Error counts for each type of error.
        # @!attribute [rw] error_counts
        #   @return [::Array<::Google::Ads::DataManager::V1::ErrorCount>]
        #     A list of errors and counts per error reason. May not be populated
        #     in all cases.
        class ErrorInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The error count for a given error reason.
        # @!attribute [rw] record_count
        #   @return [::Integer]
        #     The count of records that failed to upload for a given reason.
        # @!attribute [rw] reason
        #   @return [::Google::Ads::DataManager::V1::ProcessingErrorReason]
        #     The error reason of the failed records.
        class ErrorCount
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Warning counts for each type of warning.
        # @!attribute [rw] warning_counts
        #   @return [::Array<::Google::Ads::DataManager::V1::WarningCount>]
        #     A list of warnings and counts per warning reason.
        class WarningInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The warning count for a given warning reason.
        # @!attribute [rw] record_count
        #   @return [::Integer]
        #     The count of records that have a warning.
        # @!attribute [rw] reason
        #   @return [::Google::Ads::DataManager::V1::ProcessingWarningReason]
        #     The warning reason.
        class WarningCount
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The processing error reason.
        module ProcessingErrorReason
          # The processing error reason is unknown.
          PROCESSING_ERROR_REASON_UNSPECIFIED = 0

          # The custom variable is invalid.
          PROCESSING_ERROR_REASON_INVALID_CUSTOM_VARIABLE = 1

          # The status of the custom variable is not enabled.
          PROCESSING_ERROR_REASON_CUSTOM_VARIABLE_NOT_ENABLED = 2

          # The conversion is older than max supported age.
          PROCESSING_ERROR_REASON_EVENT_TOO_OLD = 3

          # The ad user data is denied, either by the user or in
          # the advertiser default settings.
          PROCESSING_ERROR_REASON_DENIED_CONSENT = 4

          # Advertiser did not give 3P consent for the Ads core platform services.
          PROCESSING_ERROR_REASON_NO_CONSENT = 5

          # The overall consent (determined from row level consent, request level
          # consent, and account settings) could not be determined for this user
          PROCESSING_ERROR_REASON_UNKNOWN_CONSENT = 6

          # A conversion with the same GCLID and conversion time already exists in
          # the system.
          PROCESSING_ERROR_REASON_DUPLICATE_GCLID = 7

          # A conversion with the same order id and conversion action combination was
          # already uploaded.
          PROCESSING_ERROR_REASON_DUPLICATE_TRANSACTION_ID = 8

          # The gbraid could not be decoded.
          PROCESSING_ERROR_REASON_INVALID_GBRAID = 9

          # The google click ID could not be decoded.
          PROCESSING_ERROR_REASON_INVALID_GCLID = 10

          # Merchant id contains non-digit characters.
          PROCESSING_ERROR_REASON_INVALID_MERCHANT_ID = 11

          # The wbraid could not be decoded.
          PROCESSING_ERROR_REASON_INVALID_WBRAID = 12

          # Internal error.
          PROCESSING_ERROR_REASON_INTERNAL_ERROR = 13

          # Enhanced conversions terms are not signed in the destination account.
          PROCESSING_ERROR_REASON_DESTINATION_ACCOUNT_ENHANCED_CONVERSIONS_TERMS_NOT_SIGNED = 14

          # The event is invalid.
          PROCESSING_ERROR_REASON_INVALID_EVENT = 15

          # The matched transactions are less than the minimum threshold.
          PROCESSING_ERROR_REASON_INSUFFICIENT_MATCHED_TRANSACTIONS = 16

          # The transactions are less than the minimum threshold.
          PROCESSING_ERROR_REASON_INSUFFICIENT_TRANSACTIONS = 17

          # The event has format error.
          PROCESSING_ERROR_REASON_INVALID_FORMAT = 18

          # The event has a decryption error.
          PROCESSING_ERROR_REASON_DECRYPTION_ERROR = 19

          # The DEK failed to be decrypted.
          PROCESSING_ERROR_REASON_DEK_DECRYPTION_ERROR = 20

          # The WIP is formatted incorrectly or the WIP does not exist.
          PROCESSING_ERROR_REASON_INVALID_WIP = 21

          # The KEK cannot decrypt data because it is the wrong KEK, or it does not
          # exist.
          PROCESSING_ERROR_REASON_INVALID_KEK = 22

          # The WIP could not be used because it was rejected by its attestation
          # condition.
          PROCESSING_ERROR_REASON_WIP_AUTH_FAILED = 23

          # The system did not have the permissions needed to access the KEK.
          PROCESSING_ERROR_REASON_KEK_PERMISSION_DENIED = 24

          # The system failed to authenticate with AWS.
          PROCESSING_ERROR_REASON_AWS_AUTH_FAILED = 27

          # Failed to decrypt the
          # {::Google::Ads::DataManager::V1::UserIdentifier UserIdentifier} data using the
          # DEK.
          PROCESSING_ERROR_REASON_USER_IDENTIFIER_DECRYPTION_ERROR = 25

          # The user attempted to ingest events with an ad identifier that isn't
          # from the operating account's ads.
          PROCESSING_ERROR_OPERATING_ACCOUNT_MISMATCH_FOR_AD_IDENTIFIER = 26
        end

        # The processing warning reason.
        module ProcessingWarningReason
          # The processing warning reason is unknown.
          PROCESSING_WARNING_REASON_UNSPECIFIED = 0

          # The system did not have the permissions needed to access the KEK.
          PROCESSING_WARNING_REASON_KEK_PERMISSION_DENIED = 1

          # The DEK failed to be decrypted.
          PROCESSING_WARNING_REASON_DEK_DECRYPTION_ERROR = 2

          # The event has a decryption error.
          PROCESSING_WARNING_REASON_DECRYPTION_ERROR = 3

          # The WIP could not be used because it was rejected by its attestation
          # condition.
          PROCESSING_WARNING_REASON_WIP_AUTH_FAILED = 4

          # The WIP is formatted incorrectly or the WIP does not exist.
          PROCESSING_WARNING_REASON_INVALID_WIP = 5

          # The KEK cannot decrypt data because it is the wrong KEK, or it does not
          # exist.
          PROCESSING_WARNING_REASON_INVALID_KEK = 6

          # Failed to decrypt th
          # {::Google::Ads::DataManager::V1::UserIdentifier UserIdentifier} data using the
          # DEK.
          PROCESSING_WARNING_REASON_USER_IDENTIFIER_DECRYPTION_ERROR = 7

          # Internal error.
          PROCESSING_WARNING_REASON_INTERNAL_ERROR = 8

          # The system failed to authenticate with AWS.
          PROCESSING_WARNING_REASON_AWS_AUTH_FAILED = 9
        end
      end
    end
  end
end
