# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module DataManager
      module V1
        # Request to upload audience members to the provided destinations. Returns an
        # {::Google::Ads::DataManager::V1::IngestAudienceMembersResponse IngestAudienceMembersResponse}.
        # @!attribute [rw] destinations
        #   @return [::Array<::Google::Ads::DataManager::V1::Destination>]
        #     Required. The list of destinations to send the audience members to.
        # @!attribute [rw] audience_members
        #   @return [::Array<::Google::Ads::DataManager::V1::AudienceMember>]
        #     Required. The list of users to send to the specified destinations. At most
        #     10000 {::Google::Ads::DataManager::V1::AudienceMember AudienceMember} resources
        #     can be sent in a single request.
        # @!attribute [rw] consent
        #   @return [::Google::Ads::DataManager::V1::Consent]
        #     Optional. Request-level consent to apply to all users in the request.
        #     User-level consent overrides request-level consent, and can be specified in
        #     each {::Google::Ads::DataManager::V1::AudienceMember AudienceMember}.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. For testing purposes. If `true`, the request is validated but not
        #     executed. Only errors are returned, not results.
        # @!attribute [rw] encoding
        #   @return [::Google::Ads::DataManager::V1::Encoding]
        #     Optional. Required for {::Google::Ads::DataManager::V1::UserData UserData}
        #     uploads. The encoding type of the user identifiers. For hashed user
        #     identifiers, this is the encoding type of the hashed string. For encrypted
        #     hashed user identifiers, this is the encoding type of the outer encrypted
        #     string, but not necessarily the inner hashed string, meaning the inner
        #     hashed string could be encoded in a different way than the outer encrypted
        #     string. For non `UserData` uploads, this field is ignored.
        # @!attribute [rw] encryption_info
        #   @return [::Google::Ads::DataManager::V1::EncryptionInfo]
        #     Optional. Encryption information for
        #     {::Google::Ads::DataManager::V1::UserData UserData} uploads. If not set, it's
        #     assumed that uploaded identifying information is hashed but not encrypted.
        #     For non `UserData` uploads, this field is ignored.
        # @!attribute [rw] terms_of_service
        #   @return [::Google::Ads::DataManager::V1::TermsOfService]
        #     Optional. The terms of service that the user has accepted/rejected.
        class IngestAudienceMembersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response from the
        # {::Google::Ads::DataManager::V1::IngestAudienceMembersRequest IngestAudienceMembersRequest}.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     The auto-generated ID of the request.
        class IngestAudienceMembersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to remove users from an audience in the provided destinations.
        # Returns a
        # {::Google::Ads::DataManager::V1::RemoveAudienceMembersResponse RemoveAudienceMembersResponse}.
        # @!attribute [rw] destinations
        #   @return [::Array<::Google::Ads::DataManager::V1::Destination>]
        #     Required. The list of destinations to remove the users from.
        # @!attribute [rw] audience_members
        #   @return [::Array<::Google::Ads::DataManager::V1::AudienceMember>]
        #     Required. The list of users to remove.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. For testing purposes. If `true`, the request is validated but not
        #     executed. Only errors are returned, not results.
        # @!attribute [rw] encoding
        #   @return [::Google::Ads::DataManager::V1::Encoding]
        #     Optional. Required for {::Google::Ads::DataManager::V1::UserData UserData}
        #     uploads. The encoding type of the user identifiers. Applies to only the
        #     outer encoding for encrypted user identifiers. For non `UserData` uploads,
        #     this field is ignored.
        # @!attribute [rw] encryption_info
        #   @return [::Google::Ads::DataManager::V1::EncryptionInfo]
        #     Optional. Encryption information for
        #     {::Google::Ads::DataManager::V1::UserData UserData} uploads. If not set, it's
        #     assumed that uploaded identifying information is hashed but not encrypted.
        #     For non `UserData` uploads, this field is ignored.
        class RemoveAudienceMembersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response from the
        # {::Google::Ads::DataManager::V1::RemoveAudienceMembersRequest RemoveAudienceMembersRequest}.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     The auto-generated ID of the request.
        class RemoveAudienceMembersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to upload audience members to the provided destinations. Returns an
        # {::Google::Ads::DataManager::V1::IngestEventsResponse IngestEventsResponse}.
        # @!attribute [rw] destinations
        #   @return [::Array<::Google::Ads::DataManager::V1::Destination>]
        #     Required. The list of destinations to send the events to.
        # @!attribute [rw] events
        #   @return [::Array<::Google::Ads::DataManager::V1::Event>]
        #     Required. The list of events to send to the specified destinations. At most
        #     2000 {::Google::Ads::DataManager::V1::Event Event} resources
        #     can be sent in a single request.
        # @!attribute [rw] consent
        #   @return [::Google::Ads::DataManager::V1::Consent]
        #     Optional. Request-level consent to apply to all users in the request.
        #     User-level consent overrides request-level consent, and can be specified in
        #     each {::Google::Ads::DataManager::V1::Event Event}.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. For testing purposes. If `true`, the request is validated but not
        #     executed. Only errors are returned, not results.
        # @!attribute [rw] encoding
        #   @return [::Google::Ads::DataManager::V1::Encoding]
        #     Optional. Required for {::Google::Ads::DataManager::V1::UserData UserData}
        #     uploads. The encoding type of the user identifiers. For hashed user
        #     identifiers, this is the encoding type of the hashed string. For encrypted
        #     hashed user identifiers, this is the encoding type of the outer encrypted
        #     string, but not necessarily the inner hashed string, meaning the inner
        #     hashed string could be encoded in a different way than the outer encrypted
        #     string. For non `UserData` uploads, this field is ignored.
        # @!attribute [rw] encryption_info
        #   @return [::Google::Ads::DataManager::V1::EncryptionInfo]
        #     Optional. Encryption information for
        #     {::Google::Ads::DataManager::V1::UserData UserData} uploads. If not set, it's
        #     assumed that uploaded identifying information is hashed but not encrypted.
        #     For non `UserData` uploads, this field is ignored.
        class IngestEventsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response from the
        # {::Google::Ads::DataManager::V1::IngestEventsRequest IngestEventsRequest}.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     The auto-generated ID of the request.
        class IngestEventsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get the status of request made to the DM API for a given request
        # ID. Returns a
        # {::Google::Ads::DataManager::V1::RetrieveRequestStatusResponse RetrieveRequestStatusResponse}.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Required. Required. The request ID of the Data Manager API request.
        class RetrieveRequestStatusRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response from the
        # {::Google::Ads::DataManager::V1::RetrieveRequestStatusRequest RetrieveRequestStatusRequest}.
        # @!attribute [rw] request_status_per_destination
        #   @return [::Array<::Google::Ads::DataManager::V1::RequestStatusPerDestination>]
        #     A list of request statuses per destination. The order of the statuses
        #     matches the order of the destinations in the original request.
        class RetrieveRequestStatusResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The encoding type of the hashed identifying information.
        module Encoding
          # Unspecified Encoding type. Should never be used.
          ENCODING_UNSPECIFIED = 0

          # Hex encoding.
          HEX = 1

          # Base 64 encoding.
          BASE64 = 2
        end
      end
    end
  end
end
