# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module DataManager
      module V1
        # An event representing a user interaction with an advertiser's website or app.
        # @!attribute [rw] destination_references
        #   @return [::Array<::String>]
        #     Optional. Reference string used to determine the destination. If empty, the
        #     event will be sent to all
        #     {::Google::Ads::DataManager::V1::IngestEventsRequest#destinations destinations}
        #     in the request.
        # @!attribute [rw] transaction_id
        #   @return [::String]
        #     Optional. The unique identifier for this event. Required for conversions
        #     using multiple data sources.
        # @!attribute [rw] event_timestamp
        #   @return [::Google::Protobuf::Timestamp]
        #     Required. The time the event occurred.
        # @!attribute [rw] last_updated_timestamp
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. The last time the event was updated.
        # @!attribute [rw] user_data
        #   @return [::Google::Ads::DataManager::V1::UserData]
        #     Optional. Pieces of user provided data, representing the user the event is
        #     associated with.
        # @!attribute [rw] consent
        #   @return [::Google::Ads::DataManager::V1::Consent]
        #     Optional. Information about whether the associated user has provided
        #     different types of consent.
        # @!attribute [rw] ad_identifiers
        #   @return [::Google::Ads::DataManager::V1::AdIdentifiers]
        #     Optional. Identifiers and other information used to match the conversion
        #     event with other online activity (such as ad clicks).
        # @!attribute [rw] currency
        #   @return [::String]
        #     Optional. The currency code associated with all monetary values within this
        #     event.
        # @!attribute [rw] conversion_value
        #   @return [::Float]
        #     Optional. The conversion value associated with the event, for value-based
        #     conversions.
        # @!attribute [rw] event_source
        #   @return [::Google::Ads::DataManager::V1::EventSource]
        #     Optional. Signal for where the event happened (web, app, in-store, etc.).
        # @!attribute [rw] event_device_info
        #   @return [::Google::Ads::DataManager::V1::DeviceInfo]
        #     Optional. Information gathered about the device being used (if any) when
        #     the event happened.
        # @!attribute [rw] cart_data
        #   @return [::Google::Ads::DataManager::V1::CartData]
        #     Optional. Information about the transaction and items associated with the
        #     event.
        # @!attribute [rw] custom_variables
        #   @return [::Array<::Google::Ads::DataManager::V1::CustomVariable>]
        #     Optional. Additional key/value pair information to send to the conversion
        #     containers (conversion action or FL activity).
        # @!attribute [rw] experimental_fields
        #   @return [::Array<::Google::Ads::DataManager::V1::ExperimentalField>]
        #     Optional. A list of key/value pairs for experimental fields that may
        #     eventually be promoted to be part of the API.
        # @!attribute [rw] user_properties
        #   @return [::Google::Ads::DataManager::V1::UserProperties]
        #     Optional. Advertiser-assessed information about the user at the time that
        #     the event happened.
        # @!attribute [rw] event_name
        #   @return [::String]
        #     Optional. The name of the event. Required for GA4 events.
        # @!attribute [rw] client_id
        #   @return [::String]
        #     Optional. A unique identifier for the user instance of a web client for
        #     this GA4 web stream.
        # @!attribute [rw] user_id
        #   @return [::String]
        #     Optional. A unique identifier for a user, as defined by the advertiser.
        # @!attribute [rw] additional_event_parameters
        #   @return [::Array<::Google::Ads::DataManager::V1::EventParameter>]
        #     Optional. A bucket of any [event
        #     parameters](https://developers.google.com/analytics/devguides/collection/protocol/ga4/reference/events)
        #     to be included within the event that were not already specified using other
        #     structured fields.
        class Event
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Identifiers and other information used to match the conversion event with
        # other online activity (such as ad clicks).
        # @!attribute [rw] session_attributes
        #   @return [::String]
        #     Optional. Session attributes for event attribution and modeling.
        # @!attribute [rw] gclid
        #   @return [::String]
        #     Optional. The Google click ID (gclid) associated with this event.
        # @!attribute [rw] gbraid
        #   @return [::String]
        #     Optional. The click identifier for clicks associated with app events and
        #     originating from iOS devices starting with iOS14.
        # @!attribute [rw] wbraid
        #   @return [::String]
        #     Optional. The click identifier for clicks associated with web events and
        #     originating from iOS devices starting with iOS14.
        # @!attribute [rw] landing_page_device_info
        #   @return [::Google::Ads::DataManager::V1::DeviceInfo]
        #     Optional. Information gathered about the device being used (if any) at the
        #     time of landing onto the advertiser’s site after interacting with the ad.
        class AdIdentifiers
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Custom variable for ads conversions.
        # @!attribute [rw] variable
        #   @return [::String]
        #     Optional. The name of the custom variable to set. If the variable is not
        #     found for the given destination, it will be ignored.
        # @!attribute [rw] value
        #   @return [::String]
        #     Optional. The value to store for the custom variable.
        # @!attribute [rw] destination_references
        #   @return [::Array<::String>]
        #     Optional. Reference string used to determine which of the
        #     {::Google::Ads::DataManager::V1::Event#destination_references Event.destination_references}
        #     the custom variable should be sent to. If empty, the
        #     {::Google::Ads::DataManager::V1::Event#destination_references Event.destination_references}
        #     will be used.
        class CustomVariable
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Event parameter for GA4 events.
        # @!attribute [rw] parameter_name
        #   @return [::String]
        #     Required. The name of the parameter to use.
        # @!attribute [rw] value
        #   @return [::String]
        #     Required. The string representation of the value of the parameter to set.
        class EventParameter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The source of the event.
        module EventSource
          # Unspecified EventSource. Should never be used.
          EVENT_SOURCE_UNSPECIFIED = 0

          # The event was generated from a web browser.
          WEB = 1

          # The event was generated from an app.
          APP = 2

          # The event was generated from an in-store transaction.
          IN_STORE = 3

          # The event was generated from a phone call.
          PHONE = 4

          # The event was generated from other sources.
          OTHER = 5
        end
      end
    end
  end
end
