# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module DataManager
      module V1
        # Error reasons for Data Manager API.
        module ErrorReason
          # Do not use this default value.
          ERROR_REASON_UNSPECIFIED = 0

          # An internal error has occurred.
          INTERNAL_ERROR = 1

          # The request took too long to respond.
          DEADLINE_EXCEEDED = 2

          # Too many requests.
          RESOURCE_EXHAUSTED = 3

          # Resource not found.
          NOT_FOUND = 4

          # The user does not have permission or the resource is not found.
          PERMISSION_DENIED = 5

          # There was a problem with the request.
          INVALID_ARGUMENT = 6

          # Required field is missing.
          REQUIRED_FIELD_MISSING = 7

          # Format is invalid.
          INVALID_FORMAT = 8

          # The HEX encoded value is malformed.
          INVALID_HEX_ENCODING = 9

          # The base64 encoded value is malformed.
          INVALID_BASE64_ENCODING = 10

          # The SHA256 encoded value is malformed.
          INVALID_SHA256_FORMAT = 11

          # Postal code is not valid.
          INVALID_POSTAL_CODE = 12

          # Country code is not valid.
          INVALID_COUNTRY_CODE = 13

          # Enum value cannot be used.
          INVALID_ENUM_VALUE = 14

          # Type of the user list is not applicable for this request.
          INVALID_USER_LIST_TYPE = 15

          # This audience member is not valid.
          INVALID_AUDIENCE_MEMBER = 16

          # Maximum number of audience members allowed per request is 10,000.
          TOO_MANY_AUDIENCE_MEMBERS = 17

          # Maximum number of user identifiers allowed per audience member is 10.
          TOO_MANY_USER_IDENTIFIERS = 18

          # Maximum number of destinations allowed per request is 10.
          TOO_MANY_DESTINATIONS = 19

          # This Destination is not valid.
          INVALID_DESTINATION = 20

          # Data Partner does not have access to the operating account owned userlist.
          DATA_PARTNER_USER_LIST_MUTATE_NOT_ALLOWED = 21

          # Mobile ID format is not valid.
          INVALID_MOBILE_ID_FORMAT = 22

          # User list is not valid.
          INVALID_USER_LIST_ID = 23

          # Multiple data types are not allowed to be ingested in a single request.
          MULTIPLE_DATA_TYPES_NOT_ALLOWED = 24

          # Destination configs containing a DataPartner login account must have the
          # same login account across all destination configs.
          DIFFERENT_LOGIN_ACCOUNTS_NOT_ALLOWED_FOR_DATA_PARTNER = 25

          # Required terms and conditions are not accepted.
          TERMS_AND_CONDITIONS_NOT_SIGNED = 26

          # Invalid number format.
          INVALID_NUMBER_FORMAT = 27

          # Conversion action ID is not valid.
          INVALID_CONVERSION_ACTION_ID = 28

          # The conversion action type is not valid.
          INVALID_CONVERSION_ACTION_TYPE = 29

          # The currency code is not supported.
          INVALID_CURRENCY_CODE = 30

          # This event is not valid.
          INVALID_EVENT = 31

          # Maximum number of events allowed per request is 10,000.
          TOO_MANY_EVENTS = 32

          # The destination account is not enabled for enhanced conversions for leads.
          DESTINATION_ACCOUNT_NOT_ENABLED_ENHANCED_CONVERSIONS_FOR_LEADS = 33

          # Enhanced conversions can't be used for the destination account because of
          # Google customer data policies. Contact your Google representative..
          DESTINATION_ACCOUNT_DATA_POLICY_PROHIBITS_ENHANCED_CONVERSIONS = 34

          # The destination account hasn't agreed to the terms for enhanced
          # conversions.
          DESTINATION_ACCOUNT_ENHANCED_CONVERSIONS_TERMS_NOT_SIGNED = 35

          # Two or more destinations in the request have the same reference.
          DUPLICATE_DESTINATION_REFERENCE = 36

          # Unsupported operating account for data partner authorization.
          UNSUPPORTED_OPERATING_ACCOUNT_FOR_DATA_PARTNER = 37

          # Unsupported linked account for data partner authorization.
          UNSUPPORTED_LINKED_ACCOUNT_FOR_DATA_PARTNER = 38

          # Events data contains no user identifiers or ad identifiers.
          NO_IDENTIFIERS_PROVIDED = 39

          # The property type is not supported.
          INVALID_PROPERTY_TYPE = 40

          # The stream type is not supported.
          INVALID_STREAM_TYPE = 41

          # Linked account is only supported when the login account is a `DATA_PARTNER`
          # account.
          LINKED_ACCOUNT_ONLY_ALLOWED_WITH_DATA_PARTNER_LOGIN_ACCOUNT = 42

          # The login account must be the same as the operating account for the given
          # use case.
          OPERATING_ACCOUNT_LOGIN_ACCOUNT_MISMATCH = 43

          # Event did not occur within the acceptable time window.
          EVENT_TIME_INVALID = 44

          # Parameter uses a reserved name.
          RESERVED_NAME_USED = 45

          # The event name is not supported.
          INVALID_EVENT_NAME = 46

          # The account is not allowlisted for the given feature.
          NOT_ALLOWLISTED = 47

          # The request ID used to retrieve the status of a request is not valid.
          # Status can only be retrieved for requests that succeed and don't have
          # `validate_only=true`.
          INVALID_REQUEST_ID = 48

          # An event had 2 or more Google Analytics destinations.
          MULTIPLE_DESTINATIONS_FOR_GOOGLE_ANALYTICS_EVENT = 49

          # The field value is too long.
          FIELD_VALUE_TOO_LONG = 50

          # Too many elements in a list in the request.
          TOO_MANY_ELEMENTS = 51
        end
      end
    end
  end
end
