# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module DataManager
      module V1
        # Encryption information for the data being ingested.
        # @!attribute [rw] gcp_wrapped_key_info
        #   @return [::Google::Ads::DataManager::V1::GcpWrappedKeyInfo]
        #     Google Cloud Platform wrapped key information.
        #
        #     Note: The following fields are mutually exclusive: `gcp_wrapped_key_info`, `aws_wrapped_key_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] aws_wrapped_key_info
        #   @return [::Google::Ads::DataManager::V1::AwsWrappedKeyInfo]
        #     Amazon Web Services wrapped key information.
        #
        #     Note: The following fields are mutually exclusive: `aws_wrapped_key_info`, `gcp_wrapped_key_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class EncryptionInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about the Google Cloud Platform wrapped
        # key.
        # @!attribute [rw] key_type
        #   @return [::Google::Ads::DataManager::V1::GcpWrappedKeyInfo::KeyType]
        #     Required. The type of algorithm used to encrypt the data.
        # @!attribute [rw] wip_provider
        #   @return [::String]
        #     Required. The [Workload
        #     Identity](//cloud.google.com/iam/docs/workload-identity-federation) pool
        #     provider required to use KEK.
        # @!attribute [rw] kek_uri
        #   @return [::String]
        #     Required. Google Cloud Platform [Cloud Key Management Service resource
        #     ID](//cloud.google.com/kms/docs/getting-resource-ids).  Should be in the
        #     format of
        #     "projects/\\{project}/locations/\\{location}/keyRings/\\{key_ring}/cryptoKeys/\\{key}".
        # @!attribute [rw] encrypted_dek
        #   @return [::String]
        #     Required. The base64 encoded encrypted data encryption key.
        class GcpWrappedKeyInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of algorithm used to encrypt the data.
          module KeyType
            # Unspecified key type. Should never be used.
            KEY_TYPE_UNSPECIFIED = 0

            # Algorithm XChaCha20-Poly1305
            XCHACHA20_POLY1305 = 1
          end
        end

        # A data encryption key wrapped by an AWS KMS key.
        # @!attribute [rw] key_type
        #   @return [::Google::Ads::DataManager::V1::AwsWrappedKeyInfo::KeyType]
        #     Required. The type of algorithm used to encrypt the data.
        # @!attribute [rw] role_arn
        #   @return [::String]
        #     Required. The Amazon Resource Name of the IAM Role to assume for KMS
        #     decryption access. Should be in the format of
        #     "arn:\\{partition}:iam::\\{account_id}:role/\\{role_name}"
        # @!attribute [rw] kek_uri
        #   @return [::String]
        #     Required. The URI of the AWS KMS key used to decrypt the DEK. Should be in
        #     the format of "arn:\\{partition}:kms:\\{region}:\\{account_id}:key/\\{key_id}"
        # @!attribute [rw] encrypted_dek
        #   @return [::String]
        #     Required. The base64 encoded encrypted data encryption key.
        class AwsWrappedKeyInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of algorithm used to encrypt the data.
          module KeyType
            # Unspecified key type. Should never be used.
            KEY_TYPE_UNSPECIFIED = 0

            # Algorithm XChaCha20-Poly1305
            XCHACHA20_POLY1305 = 1
          end
        end
      end
    end
  end
end
