# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module DataManager
      module V1
        # The Google product you're sending data to. For example, a Google
        # Ads account.
        # @!attribute [rw] reference
        #   @return [::String]
        #     Optional. ID for this `Destination` resource, unique within the request.
        #     Use to reference this `Destination` in  the
        #     {::Google::Ads::DataManager::V1::IngestEventsRequest IngestEventsRequest} and
        #     {::Google::Ads::DataManager::V1::IngestAudienceMembersRequest IngestAudienceMembersRequest}.
        # @!attribute [rw] login_account
        #   @return [::Google::Ads::DataManager::V1::ProductAccount]
        #     Optional. The account used to make this API call. To add or remove data
        #     from the
        #     {::Google::Ads::DataManager::V1::Destination#operating_account `operating_account`},
        #     this `login_account` must have write access to the `operating_account`. For
        #     example, a manager account of the `operating_account`, or an account with
        #     an established link to the `operating_account`.
        # @!attribute [rw] linked_account
        #   @return [::Google::Ads::DataManager::V1::ProductAccount]
        #     Optional. An account that the calling user's
        #     {::Google::Ads::DataManager::V1::Destination#login_account `login_account`} has
        #     access to, through an established account link. For example, a data
        #     partner's `login_account` might have access to a client's `linked_account`.
        #     The partner might use this field to send data from the `linked_account` to
        #     another
        #     {::Google::Ads::DataManager::V1::Destination#operating_account `operating_account`}.
        # @!attribute [rw] operating_account
        #   @return [::Google::Ads::DataManager::V1::ProductAccount]
        #     Required. The account to send the data to or remove the data from.
        # @!attribute [rw] product_destination_id
        #   @return [::String]
        #     Required. The object within the product account to ingest into. For
        #     example, a Google Ads audience ID, a Display & Video 360 audience ID or a
        #     Google Ads conversion action ID.
        class Destination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a specific account.
        # @!attribute [rw] product
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Ads::DataManager::V1::Product]
        #     Deprecated. Use
        #     {::Google::Ads::DataManager::V1::ProductAccount#account_type `account_type`}
        #     instead.
        # @!attribute [rw] account_id
        #   @return [::String]
        #     Required. The ID of the account. For example, your Google Ads account ID.
        # @!attribute [rw] account_type
        #   @return [::Google::Ads::DataManager::V1::ProductAccount::AccountType]
        #     Optional. The type of the account. For example, `GOOGLE_ADS`.
        #     Either `account_type` or the deprecated `product` is required.
        #     If both are set, the values must match.
        class ProductAccount
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents Google account types. Used to locate accounts and
          # destinations.
          module AccountType
            # Unspecified product. Should never be used.
            ACCOUNT_TYPE_UNSPECIFIED = 0

            # Google Ads.
            GOOGLE_ADS = 1

            # Display & Video 360 partner.
            DISPLAY_VIDEO_PARTNER = 2

            # Display & Video 360 advertiser.
            DISPLAY_VIDEO_ADVERTISER = 3

            # Data Partner.
            DATA_PARTNER = 4

            # Google Analytics.
            GOOGLE_ANALYTICS_PROPERTY = 5
          end
        end

        # Deprecated. Use
        # {::Google::Ads::DataManager::V1::ProductAccount::AccountType `AccountType`}
        # instead. Represents a specific Google product.
        # @deprecated This enum is deprecated and may be removed in the next major version update.
        module Product
          # Unspecified product. Should never be used.
          PRODUCT_UNSPECIFIED = 0

          # Google Ads.
          GOOGLE_ADS = 1

          # Display & Video 360 partner.
          DISPLAY_VIDEO_PARTNER = 2

          # Display & Video 360 advertiser.
          DISPLAY_VIDEO_ADVERTISER = 3

          # Data Partner.
          DATA_PARTNER = 4
        end
      end
    end
  end
end
