# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module DataManager
      module V1
        # The cart data associated with the event.
        # @!attribute [rw] merchant_id
        #   @return [::String]
        #     Optional. The Merchant Center ID associated with the items.
        # @!attribute [rw] merchant_feed_label
        #   @return [::String]
        #     Optional. The Merchant Center feed label associated with the feed of the
        #     items.
        # @!attribute [rw] merchant_feed_language_code
        #   @return [::String]
        #     Optional. The language code in ISO 639-1 associated with the Merchant
        #     Center feed of the items.where your items are uploaded.
        # @!attribute [rw] transaction_discount
        #   @return [::Float]
        #     Optional. The sum of all discounts associated with the transaction.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Ads::DataManager::V1::Item>]
        #     Optional. The list of items associated with the event.
        class CartData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an item in the cart associated with the event.
        # @!attribute [rw] merchant_product_id
        #   @return [::String]
        #     Optional. The product ID within the Merchant Center account.
        # @!attribute [rw] quantity
        #   @return [::Integer]
        #     Optional. The number of this item associated with the event.
        # @!attribute [rw] unit_price
        #   @return [::Float]
        #     Optional. The unit price excluding tax, shipping, and any transaction level
        #     discounts.
        # @!attribute [rw] item_id
        #   @return [::String]
        #     Optional. A unique identifier to reference the item.
        # @!attribute [rw] additional_item_parameters
        #   @return [::Array<::Google::Ads::DataManager::V1::ItemParameter>]
        #     Optional. A bucket of any [event parameters related to an
        #     item](https://developers.google.com/analytics/devguides/collection/protocol/ga4/reference/events)
        #     to be included within the event that were not already specified using other
        #     structured fields.
        class Item
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
