# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module DataManager
      module V1
        # The audience member to be operated on.
        # @!attribute [rw] destination_references
        #   @return [::Array<::String>]
        #     Optional. Defines which
        #     {::Google::Ads::DataManager::V1::Destination Destination} to send the audience
        #     member to.
        # @!attribute [rw] user_data
        #   @return [::Google::Ads::DataManager::V1::UserData]
        #     User-provided data that identifies the user.
        #
        #     Note: The following fields are mutually exclusive: `user_data`, `pair_data`, `mobile_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] pair_data
        #   @return [::Google::Ads::DataManager::V1::PairData]
        #     [Publisher Advertiser Identity Reconciliation (PAIR)
        #     IDs](//support.google.com/admanager/answer/15067908).
        #
        #     Note: The following fields are mutually exclusive: `pair_data`, `user_data`, `mobile_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] mobile_data
        #   @return [::Google::Ads::DataManager::V1::MobileData]
        #     Data identifying the user's mobile devices.
        #
        #     Note: The following fields are mutually exclusive: `mobile_data`, `user_data`, `pair_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] consent
        #   @return [::Google::Ads::DataManager::V1::Consent]
        #     Optional. The consent setting for the user.
        class AudienceMember
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # [PAIR](//support.google.com/admanager/answer/15067908) IDs for the audience.
        # At least one PAIR ID is required.
        # @!attribute [rw] pair_ids
        #   @return [::Array<::String>]
        #     Required. Cleanroom-provided PII data, hashed with SHA256, and encrypted
        #     with an EC commutative cipher using publisher key for the
        #     [PAIR]((//support.google.com/admanager/answer/15067908)) user list. At most
        #     10 `pairIds` can be provided in a single
        #     {::Google::Ads::DataManager::V1::AudienceMember AudienceMember}.
        class PairData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Mobile IDs for the audience. At least one mobile ID is required.
        # @!attribute [rw] mobile_ids
        #   @return [::Array<::String>]
        #     Required. The list of mobile device IDs (advertising ID/IDFA). At most 10
        #     `mobileIds` can be provided in a single
        #     {::Google::Ads::DataManager::V1::AudienceMember AudienceMember}.
        class MobileData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
