# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/ads/datamanager/v1/ingestion_service_pb"
require "google/ads/data_manager/v1/ingestion_service/rest/service_stub"

module Google
  module Ads
    module DataManager
      module V1
        module IngestionService
          module Rest
            ##
            # REST client for the IngestionService service.
            #
            # Service for sending audience data to supported destinations.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "datamanager.$UNIVERSE_DOMAIN$"

              # @private
              attr_reader :ingestion_service_stub

              ##
              # Configure the IngestionService Client class.
              #
              # See {::Google::Ads::DataManager::V1::IngestionService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all IngestionService clients
              #   ::Google::Ads::DataManager::V1::IngestionService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Ads", "DataManager", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the IngestionService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Ads::DataManager::V1::IngestionService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @ingestion_service_stub.universe_domain
              end

              ##
              # Create a new IngestionService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Ads::DataManager::V1::IngestionService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Ads::DataManager::V1::IngestionService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the IngestionService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @ingestion_service_stub = ::Google::Ads::DataManager::V1::IngestionService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @ingestion_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @ingestion_service_stub.logger
              end

              # Service calls

              ##
              # Uploads a list of
              # {::Google::Ads::DataManager::V1::AudienceMember AudienceMember} resources to the
              # provided {::Google::Ads::DataManager::V1::Destination Destination}.
              #
              # @overload ingest_audience_members(request, options = nil)
              #   Pass arguments to `ingest_audience_members` via a request object, either of type
              #   {::Google::Ads::DataManager::V1::IngestAudienceMembersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::DataManager::V1::IngestAudienceMembersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload ingest_audience_members(destinations: nil, audience_members: nil, consent: nil, validate_only: nil, encoding: nil, encryption_info: nil, terms_of_service: nil)
              #   Pass arguments to `ingest_audience_members` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param destinations [::Array<::Google::Ads::DataManager::V1::Destination, ::Hash>]
              #     Required. The list of destinations to send the audience members to.
              #   @param audience_members [::Array<::Google::Ads::DataManager::V1::AudienceMember, ::Hash>]
              #     Required. The list of users to send to the specified destinations. At most
              #     10000 {::Google::Ads::DataManager::V1::AudienceMember AudienceMember} resources
              #     can be sent in a single request.
              #   @param consent [::Google::Ads::DataManager::V1::Consent, ::Hash]
              #     Optional. Request-level consent to apply to all users in the request.
              #     User-level consent overrides request-level consent, and can be specified in
              #     each {::Google::Ads::DataManager::V1::AudienceMember AudienceMember}.
              #   @param validate_only [::Boolean]
              #     Optional. For testing purposes. If `true`, the request is validated but not
              #     executed. Only errors are returned, not results.
              #   @param encoding [::Google::Ads::DataManager::V1::Encoding]
              #     Optional. Required for {::Google::Ads::DataManager::V1::UserData UserData}
              #     uploads. The encoding type of the user identifiers. For hashed user
              #     identifiers, this is the encoding type of the hashed string. For encrypted
              #     hashed user identifiers, this is the encoding type of the outer encrypted
              #     string, but not necessarily the inner hashed string, meaning the inner
              #     hashed string could be encoded in a different way than the outer encrypted
              #     string. For non `UserData` uploads, this field is ignored.
              #   @param encryption_info [::Google::Ads::DataManager::V1::EncryptionInfo, ::Hash]
              #     Optional. Encryption information for
              #     {::Google::Ads::DataManager::V1::UserData UserData} uploads. If not set, it's
              #     assumed that uploaded identifying information is hashed but not encrypted.
              #     For non `UserData` uploads, this field is ignored.
              #   @param terms_of_service [::Google::Ads::DataManager::V1::TermsOfService, ::Hash]
              #     Optional. The terms of service that the user has accepted/rejected.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Ads::DataManager::V1::IngestAudienceMembersResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Ads::DataManager::V1::IngestAudienceMembersResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/ads/data_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::DataManager::V1::IngestionService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::DataManager::V1::IngestAudienceMembersRequest.new
              #
              #   # Call the ingest_audience_members method.
              #   result = client.ingest_audience_members request
              #
              #   # The returned object is of type Google::Ads::DataManager::V1::IngestAudienceMembersResponse.
              #   p result
              #
              def ingest_audience_members request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::DataManager::V1::IngestAudienceMembersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.ingest_audience_members.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::DataManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.ingest_audience_members.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.ingest_audience_members.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @ingestion_service_stub.ingest_audience_members request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Removes a list of
              # {::Google::Ads::DataManager::V1::AudienceMember AudienceMember} resources from
              # the provided {::Google::Ads::DataManager::V1::Destination Destination}.
              #
              # @overload remove_audience_members(request, options = nil)
              #   Pass arguments to `remove_audience_members` via a request object, either of type
              #   {::Google::Ads::DataManager::V1::RemoveAudienceMembersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::DataManager::V1::RemoveAudienceMembersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload remove_audience_members(destinations: nil, audience_members: nil, validate_only: nil, encoding: nil, encryption_info: nil)
              #   Pass arguments to `remove_audience_members` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param destinations [::Array<::Google::Ads::DataManager::V1::Destination, ::Hash>]
              #     Required. The list of destinations to remove the users from.
              #   @param audience_members [::Array<::Google::Ads::DataManager::V1::AudienceMember, ::Hash>]
              #     Required. The list of users to remove.
              #   @param validate_only [::Boolean]
              #     Optional. For testing purposes. If `true`, the request is validated but not
              #     executed. Only errors are returned, not results.
              #   @param encoding [::Google::Ads::DataManager::V1::Encoding]
              #     Optional. Required for {::Google::Ads::DataManager::V1::UserData UserData}
              #     uploads. The encoding type of the user identifiers. Applies to only the
              #     outer encoding for encrypted user identifiers. For non `UserData` uploads,
              #     this field is ignored.
              #   @param encryption_info [::Google::Ads::DataManager::V1::EncryptionInfo, ::Hash]
              #     Optional. Encryption information for
              #     {::Google::Ads::DataManager::V1::UserData UserData} uploads. If not set, it's
              #     assumed that uploaded identifying information is hashed but not encrypted.
              #     For non `UserData` uploads, this field is ignored.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Ads::DataManager::V1::RemoveAudienceMembersResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Ads::DataManager::V1::RemoveAudienceMembersResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/ads/data_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::DataManager::V1::IngestionService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::DataManager::V1::RemoveAudienceMembersRequest.new
              #
              #   # Call the remove_audience_members method.
              #   result = client.remove_audience_members request
              #
              #   # The returned object is of type Google::Ads::DataManager::V1::RemoveAudienceMembersResponse.
              #   p result
              #
              def remove_audience_members request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::DataManager::V1::RemoveAudienceMembersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.remove_audience_members.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::DataManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.remove_audience_members.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.remove_audience_members.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @ingestion_service_stub.remove_audience_members request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Uploads a list of
              # {::Google::Ads::DataManager::V1::Event Event} resources from
              # the provided {::Google::Ads::DataManager::V1::Destination Destination}.
              #
              # @overload ingest_events(request, options = nil)
              #   Pass arguments to `ingest_events` via a request object, either of type
              #   {::Google::Ads::DataManager::V1::IngestEventsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::DataManager::V1::IngestEventsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload ingest_events(destinations: nil, events: nil, consent: nil, validate_only: nil, encoding: nil, encryption_info: nil)
              #   Pass arguments to `ingest_events` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param destinations [::Array<::Google::Ads::DataManager::V1::Destination, ::Hash>]
              #     Required. The list of destinations to send the events to.
              #   @param events [::Array<::Google::Ads::DataManager::V1::Event, ::Hash>]
              #     Required. The list of events to send to the specified destinations. At most
              #     2000 {::Google::Ads::DataManager::V1::Event Event} resources
              #     can be sent in a single request.
              #   @param consent [::Google::Ads::DataManager::V1::Consent, ::Hash]
              #     Optional. Request-level consent to apply to all users in the request.
              #     User-level consent overrides request-level consent, and can be specified in
              #     each {::Google::Ads::DataManager::V1::Event Event}.
              #   @param validate_only [::Boolean]
              #     Optional. For testing purposes. If `true`, the request is validated but not
              #     executed. Only errors are returned, not results.
              #   @param encoding [::Google::Ads::DataManager::V1::Encoding]
              #     Optional. Required for {::Google::Ads::DataManager::V1::UserData UserData}
              #     uploads. The encoding type of the user identifiers. For hashed user
              #     identifiers, this is the encoding type of the hashed string. For encrypted
              #     hashed user identifiers, this is the encoding type of the outer encrypted
              #     string, but not necessarily the inner hashed string, meaning the inner
              #     hashed string could be encoded in a different way than the outer encrypted
              #     string. For non `UserData` uploads, this field is ignored.
              #   @param encryption_info [::Google::Ads::DataManager::V1::EncryptionInfo, ::Hash]
              #     Optional. Encryption information for
              #     {::Google::Ads::DataManager::V1::UserData UserData} uploads. If not set, it's
              #     assumed that uploaded identifying information is hashed but not encrypted.
              #     For non `UserData` uploads, this field is ignored.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Ads::DataManager::V1::IngestEventsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Ads::DataManager::V1::IngestEventsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/ads/data_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::DataManager::V1::IngestionService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::DataManager::V1::IngestEventsRequest.new
              #
              #   # Call the ingest_events method.
              #   result = client.ingest_events request
              #
              #   # The returned object is of type Google::Ads::DataManager::V1::IngestEventsResponse.
              #   p result
              #
              def ingest_events request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::DataManager::V1::IngestEventsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.ingest_events.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::DataManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.ingest_events.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.ingest_events.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @ingestion_service_stub.ingest_events request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the status of a request given request id.
              #
              # @overload retrieve_request_status(request, options = nil)
              #   Pass arguments to `retrieve_request_status` via a request object, either of type
              #   {::Google::Ads::DataManager::V1::RetrieveRequestStatusRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::DataManager::V1::RetrieveRequestStatusRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload retrieve_request_status(request_id: nil)
              #   Pass arguments to `retrieve_request_status` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param request_id [::String]
              #     Required. Required. The request ID of the Data Manager API request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Ads::DataManager::V1::RetrieveRequestStatusResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Ads::DataManager::V1::RetrieveRequestStatusResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/ads/data_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::DataManager::V1::IngestionService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::DataManager::V1::RetrieveRequestStatusRequest.new
              #
              #   # Call the retrieve_request_status method.
              #   result = client.retrieve_request_status request
              #
              #   # The returned object is of type Google::Ads::DataManager::V1::RetrieveRequestStatusResponse.
              #   p result
              #
              def retrieve_request_status request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::DataManager::V1::RetrieveRequestStatusRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.retrieve_request_status.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::DataManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.retrieve_request_status.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.retrieve_request_status.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @ingestion_service_stub.retrieve_request_status request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the IngestionService REST API.
              #
              # This class represents the configuration for IngestionService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Ads::DataManager::V1::IngestionService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # ingest_audience_members to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Ads::DataManager::V1::IngestionService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.ingest_audience_members.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Ads::DataManager::V1::IngestionService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.ingest_audience_members.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "datamanager.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the IngestionService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `ingest_audience_members`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :ingest_audience_members
                  ##
                  # RPC-specific configuration for `remove_audience_members`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :remove_audience_members
                  ##
                  # RPC-specific configuration for `ingest_events`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :ingest_events
                  ##
                  # RPC-specific configuration for `retrieve_request_status`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :retrieve_request_status

                  # @private
                  def initialize parent_rpcs = nil
                    ingest_audience_members_config = parent_rpcs.ingest_audience_members if parent_rpcs.respond_to? :ingest_audience_members
                    @ingest_audience_members = ::Gapic::Config::Method.new ingest_audience_members_config
                    remove_audience_members_config = parent_rpcs.remove_audience_members if parent_rpcs.respond_to? :remove_audience_members
                    @remove_audience_members = ::Gapic::Config::Method.new remove_audience_members_config
                    ingest_events_config = parent_rpcs.ingest_events if parent_rpcs.respond_to? :ingest_events
                    @ingest_events = ::Gapic::Config::Method.new ingest_events_config
                    retrieve_request_status_config = parent_rpcs.retrieve_request_status if parent_rpcs.respond_to? :retrieve_request_status
                    @retrieve_request_status = ::Gapic::Config::Method.new retrieve_request_status_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
