# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "google/ads/ad_manager"
require "gapic/common"
require "gapic/rest"

class Google::Ads::AdManager::ClientConstructionMinitest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_ad_break_service_rest
    skip unless Google::Ads::AdManager.ad_break_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.ad_break_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::AdBreakService::Rest::Client, client
    end
  end

  def test_ad_review_center_ad_service_rest
    skip unless Google::Ads::AdManager.ad_review_center_ad_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.ad_review_center_ad_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::AdReviewCenterAdService::Rest::Client, client
    end
  end

  def test_ad_unit_service_rest
    skip unless Google::Ads::AdManager.ad_unit_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.ad_unit_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::AdUnitService::Rest::Client, client
    end
  end

  def test_application_service_rest
    skip unless Google::Ads::AdManager.application_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.application_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::ApplicationService::Rest::Client, client
    end
  end

  def test_audience_segment_service_rest
    skip unless Google::Ads::AdManager.audience_segment_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.audience_segment_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::AudienceSegmentService::Rest::Client, client
    end
  end

  def test_bandwidth_group_service_rest
    skip unless Google::Ads::AdManager.bandwidth_group_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.bandwidth_group_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::BandwidthGroupService::Rest::Client, client
    end
  end

  def test_browser_language_service_rest
    skip unless Google::Ads::AdManager.browser_language_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.browser_language_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::BrowserLanguageService::Rest::Client, client
    end
  end

  def test_browser_service_rest
    skip unless Google::Ads::AdManager.browser_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.browser_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::BrowserService::Rest::Client, client
    end
  end

  def test_cms_metadata_key_service_rest
    skip unless Google::Ads::AdManager.cms_metadata_key_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.cms_metadata_key_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::CmsMetadataKeyService::Rest::Client, client
    end
  end

  def test_cms_metadata_value_service_rest
    skip unless Google::Ads::AdManager.cms_metadata_value_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.cms_metadata_value_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::CmsMetadataValueService::Rest::Client, client
    end
  end

  def test_company_service_rest
    skip unless Google::Ads::AdManager.company_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.company_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::CompanyService::Rest::Client, client
    end
  end

  def test_contact_service_rest
    skip unless Google::Ads::AdManager.contact_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.contact_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::ContactService::Rest::Client, client
    end
  end

  def test_content_bundle_service_rest
    skip unless Google::Ads::AdManager.content_bundle_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.content_bundle_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::ContentBundleService::Rest::Client, client
    end
  end

  def test_content_label_service_rest
    skip unless Google::Ads::AdManager.content_label_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.content_label_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::ContentLabelService::Rest::Client, client
    end
  end

  def test_content_service_rest
    skip unless Google::Ads::AdManager.content_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.content_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::ContentService::Rest::Client, client
    end
  end

  def test_creative_template_service_rest
    skip unless Google::Ads::AdManager.creative_template_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.creative_template_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::CreativeTemplateService::Rest::Client, client
    end
  end

  def test_custom_field_service_rest
    skip unless Google::Ads::AdManager.custom_field_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.custom_field_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::CustomFieldService::Rest::Client, client
    end
  end

  def test_custom_targeting_key_service_rest
    skip unless Google::Ads::AdManager.custom_targeting_key_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.custom_targeting_key_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::CustomTargetingKeyService::Rest::Client, client
    end
  end

  def test_custom_targeting_value_service_rest
    skip unless Google::Ads::AdManager.custom_targeting_value_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.custom_targeting_value_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::CustomTargetingValueService::Rest::Client, client
    end
  end

  def test_device_capability_service_rest
    skip unless Google::Ads::AdManager.device_capability_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.device_capability_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::DeviceCapabilityService::Rest::Client, client
    end
  end

  def test_device_category_service_rest
    skip unless Google::Ads::AdManager.device_category_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.device_category_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::DeviceCategoryService::Rest::Client, client
    end
  end

  def test_device_manufacturer_service_rest
    skip unless Google::Ads::AdManager.device_manufacturer_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.device_manufacturer_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::DeviceManufacturerService::Rest::Client, client
    end
  end

  def test_entity_signals_mapping_service_rest
    skip unless Google::Ads::AdManager.entity_signals_mapping_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.entity_signals_mapping_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::EntitySignalsMappingService::Rest::Client, client
    end
  end

  def test_geo_target_service_rest
    skip unless Google::Ads::AdManager.geo_target_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.geo_target_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::GeoTargetService::Rest::Client, client
    end
  end

  def test_line_item_service_rest
    skip unless Google::Ads::AdManager.line_item_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.line_item_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::LineItemService::Rest::Client, client
    end
  end

  def test_mobile_carrier_service_rest
    skip unless Google::Ads::AdManager.mobile_carrier_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.mobile_carrier_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::MobileCarrierService::Rest::Client, client
    end
  end

  def test_mobile_device_service_rest
    skip unless Google::Ads::AdManager.mobile_device_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.mobile_device_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::MobileDeviceService::Rest::Client, client
    end
  end

  def test_mobile_device_submodel_service_rest
    skip unless Google::Ads::AdManager.mobile_device_submodel_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.mobile_device_submodel_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::MobileDeviceSubmodelService::Rest::Client, client
    end
  end

  def test_network_service_rest
    skip unless Google::Ads::AdManager.network_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.network_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::NetworkService::Rest::Client, client
    end
  end

  def test_operating_system_service_rest
    skip unless Google::Ads::AdManager.operating_system_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.operating_system_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::OperatingSystemService::Rest::Client, client
    end
  end

  def test_operating_system_version_service_rest
    skip unless Google::Ads::AdManager.operating_system_version_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.operating_system_version_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::OperatingSystemVersionService::Rest::Client, client
    end
  end

  def test_order_service_rest
    skip unless Google::Ads::AdManager.order_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.order_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::OrderService::Rest::Client, client
    end
  end

  def test_placement_service_rest
    skip unless Google::Ads::AdManager.placement_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.placement_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::PlacementService::Rest::Client, client
    end
  end

  def test_private_auction_deal_service_rest
    skip unless Google::Ads::AdManager.private_auction_deal_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.private_auction_deal_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::PrivateAuctionDealService::Rest::Client, client
    end
  end

  def test_private_auction_service_rest
    skip unless Google::Ads::AdManager.private_auction_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.private_auction_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::PrivateAuctionService::Rest::Client, client
    end
  end

  def test_programmatic_buyer_service_rest
    skip unless Google::Ads::AdManager.programmatic_buyer_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.programmatic_buyer_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::ProgrammaticBuyerService::Rest::Client, client
    end
  end

  def test_report_service_rest
    skip unless Google::Ads::AdManager.report_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.report_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::ReportService::Rest::Client, client
    end
  end

  def test_role_service_rest
    skip unless Google::Ads::AdManager.role_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.role_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::RoleService::Rest::Client, client
    end
  end

  def test_site_service_rest
    skip unless Google::Ads::AdManager.site_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.site_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::SiteService::Rest::Client, client
    end
  end

  def test_taxonomy_category_service_rest
    skip unless Google::Ads::AdManager.taxonomy_category_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.taxonomy_category_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::TaxonomyCategoryService::Rest::Client, client
    end
  end

  def test_team_service_rest
    skip unless Google::Ads::AdManager.team_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.team_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::TeamService::Rest::Client, client
    end
  end

  def test_user_service_rest
    skip unless Google::Ads::AdManager.user_service_available?
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Ads::AdManager.user_service do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Ads::AdManager::V1::UserService::Rest::Client, client
    end
  end
end
