# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# Require this file early so that the version constant gets defined before
# requiring "google/cloud". This is because google-cloud-core will load the
# entrypoint (gem name) file, which in turn re-requires this file (hence
# causing a require cycle) unless the version constant is already defined.
require "google/ads/ad_manager/version"

require "googleauth"

module Google
  module Ads
    module AdManager
      ##
      # Create a new client object for AdBreakService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::AdBreakService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/AdBreakService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the AdBreakService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the AdBreakService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.ad_break_service_available?}.
      #
      # ## About AdBreakService
      #
      # Provides methods for handling `AdBreak` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.ad_break_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:AdBreakService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the AdBreakService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.ad_break_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the AdBreakService service,
      # or if the versioned client gem needs an update to support the AdBreakService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.ad_break_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :AdBreakService
        service_module = service_module.const_get :AdBreakService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for AdReviewCenterAdService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::AdReviewCenterAdService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/AdReviewCenterAdService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the AdReviewCenterAdService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the AdReviewCenterAdService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.ad_review_center_ad_service_available?}.
      #
      # ## About AdReviewCenterAdService
      #
      # Provides methods for handling AdReviewCenterAd objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.ad_review_center_ad_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:AdReviewCenterAdService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the AdReviewCenterAdService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.ad_review_center_ad_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the AdReviewCenterAdService service,
      # or if the versioned client gem needs an update to support the AdReviewCenterAdService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.ad_review_center_ad_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :AdReviewCenterAdService
        service_module = service_module.const_get :AdReviewCenterAdService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for AdUnitService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::AdUnitService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/AdUnitService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the AdUnitService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the AdUnitService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.ad_unit_service_available?}.
      #
      # ## About AdUnitService
      #
      # Provides methods for handling AdUnit objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.ad_unit_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:AdUnitService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the AdUnitService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.ad_unit_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the AdUnitService service,
      # or if the versioned client gem needs an update to support the AdUnitService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.ad_unit_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :AdUnitService
        service_module = service_module.const_get :AdUnitService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ApplicationService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::ApplicationService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/ApplicationService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ApplicationService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the ApplicationService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.application_service_available?}.
      #
      # ## About ApplicationService
      #
      # Provides methods for handling `Application` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.application_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:ApplicationService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ApplicationService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.application_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ApplicationService service,
      # or if the versioned client gem needs an update to support the ApplicationService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.application_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :ApplicationService
        service_module = service_module.const_get :ApplicationService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for AudienceSegmentService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::AudienceSegmentService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/AudienceSegmentService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the AudienceSegmentService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the AudienceSegmentService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.audience_segment_service_available?}.
      #
      # ## About AudienceSegmentService
      #
      # Provides methods for handling `AudienceSegment` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.audience_segment_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:AudienceSegmentService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the AudienceSegmentService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.audience_segment_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the AudienceSegmentService service,
      # or if the versioned client gem needs an update to support the AudienceSegmentService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.audience_segment_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :AudienceSegmentService
        service_module = service_module.const_get :AudienceSegmentService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for BandwidthGroupService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::BandwidthGroupService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/BandwidthGroupService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the BandwidthGroupService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the BandwidthGroupService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.bandwidth_group_service_available?}.
      #
      # ## About BandwidthGroupService
      #
      # Provides methods for handling `BandwidthGroup` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.bandwidth_group_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:BandwidthGroupService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the BandwidthGroupService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.bandwidth_group_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the BandwidthGroupService service,
      # or if the versioned client gem needs an update to support the BandwidthGroupService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.bandwidth_group_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :BandwidthGroupService
        service_module = service_module.const_get :BandwidthGroupService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for BrowserLanguageService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::BrowserLanguageService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/BrowserLanguageService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the BrowserLanguageService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the BrowserLanguageService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.browser_language_service_available?}.
      #
      # ## About BrowserLanguageService
      #
      # Provides methods for handling `BrowserLanguage` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.browser_language_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:BrowserLanguageService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the BrowserLanguageService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.browser_language_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the BrowserLanguageService service,
      # or if the versioned client gem needs an update to support the BrowserLanguageService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.browser_language_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :BrowserLanguageService
        service_module = service_module.const_get :BrowserLanguageService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for BrowserService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::BrowserService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/BrowserService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the BrowserService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the BrowserService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.browser_service_available?}.
      #
      # ## About BrowserService
      #
      # Provides methods for handling `Browser` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.browser_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:BrowserService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the BrowserService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.browser_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the BrowserService service,
      # or if the versioned client gem needs an update to support the BrowserService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.browser_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :BrowserService
        service_module = service_module.const_get :BrowserService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for CmsMetadataKeyService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::CmsMetadataKeyService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/CmsMetadataKeyService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the CmsMetadataKeyService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the CmsMetadataKeyService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.cms_metadata_key_service_available?}.
      #
      # ## About CmsMetadataKeyService
      #
      # Provides methods for handling `CmsMetadataKey` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.cms_metadata_key_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:CmsMetadataKeyService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the CmsMetadataKeyService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.cms_metadata_key_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the CmsMetadataKeyService service,
      # or if the versioned client gem needs an update to support the CmsMetadataKeyService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.cms_metadata_key_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :CmsMetadataKeyService
        service_module = service_module.const_get :CmsMetadataKeyService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for CmsMetadataValueService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::CmsMetadataValueService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/CmsMetadataValueService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the CmsMetadataValueService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the CmsMetadataValueService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.cms_metadata_value_service_available?}.
      #
      # ## About CmsMetadataValueService
      #
      # Provides methods for handling `CmsMetadataValue` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.cms_metadata_value_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:CmsMetadataValueService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the CmsMetadataValueService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.cms_metadata_value_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the CmsMetadataValueService service,
      # or if the versioned client gem needs an update to support the CmsMetadataValueService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.cms_metadata_value_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :CmsMetadataValueService
        service_module = service_module.const_get :CmsMetadataValueService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for CompanyService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::CompanyService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/CompanyService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the CompanyService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the CompanyService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.company_service_available?}.
      #
      # ## About CompanyService
      #
      # Provides methods for handling `Company` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.company_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:CompanyService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the CompanyService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.company_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the CompanyService service,
      # or if the versioned client gem needs an update to support the CompanyService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.company_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :CompanyService
        service_module = service_module.const_get :CompanyService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ContactService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::ContactService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/ContactService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ContactService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the ContactService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.contact_service_available?}.
      #
      # ## About ContactService
      #
      # Provides methods for handling `Contact` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.contact_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:ContactService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ContactService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.contact_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ContactService service,
      # or if the versioned client gem needs an update to support the ContactService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.contact_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :ContactService
        service_module = service_module.const_get :ContactService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ContentBundleService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::ContentBundleService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/ContentBundleService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ContentBundleService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the ContentBundleService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.content_bundle_service_available?}.
      #
      # ## About ContentBundleService
      #
      # Provides methods for handling `ContentBundle` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.content_bundle_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:ContentBundleService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ContentBundleService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.content_bundle_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ContentBundleService service,
      # or if the versioned client gem needs an update to support the ContentBundleService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.content_bundle_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :ContentBundleService
        service_module = service_module.const_get :ContentBundleService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ContentLabelService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::ContentLabelService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/ContentLabelService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ContentLabelService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the ContentLabelService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.content_label_service_available?}.
      #
      # ## About ContentLabelService
      #
      # Provides methods for handling `ContentLabel` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.content_label_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:ContentLabelService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ContentLabelService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.content_label_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ContentLabelService service,
      # or if the versioned client gem needs an update to support the ContentLabelService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.content_label_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :ContentLabelService
        service_module = service_module.const_get :ContentLabelService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ContentService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::ContentService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/ContentService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ContentService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the ContentService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.content_service_available?}.
      #
      # ## About ContentService
      #
      # Provides methods for handling `Content` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.content_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:ContentService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ContentService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.content_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ContentService service,
      # or if the versioned client gem needs an update to support the ContentService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.content_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :ContentService
        service_module = service_module.const_get :ContentService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for CreativeTemplateService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::CreativeTemplateService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/CreativeTemplateService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the CreativeTemplateService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the CreativeTemplateService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.creative_template_service_available?}.
      #
      # ## About CreativeTemplateService
      #
      # Provides methods for handling `CreativeTemplate` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.creative_template_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:CreativeTemplateService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the CreativeTemplateService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.creative_template_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the CreativeTemplateService service,
      # or if the versioned client gem needs an update to support the CreativeTemplateService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.creative_template_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :CreativeTemplateService
        service_module = service_module.const_get :CreativeTemplateService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for CustomFieldService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::CustomFieldService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/CustomFieldService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the CustomFieldService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the CustomFieldService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.custom_field_service_available?}.
      #
      # ## About CustomFieldService
      #
      # Provides methods for handling `CustomField` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.custom_field_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:CustomFieldService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the CustomFieldService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.custom_field_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the CustomFieldService service,
      # or if the versioned client gem needs an update to support the CustomFieldService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.custom_field_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :CustomFieldService
        service_module = service_module.const_get :CustomFieldService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for CustomTargetingKeyService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::CustomTargetingKeyService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/CustomTargetingKeyService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the CustomTargetingKeyService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the CustomTargetingKeyService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.custom_targeting_key_service_available?}.
      #
      # ## About CustomTargetingKeyService
      #
      # Provides methods for handling `CustomTargetingKey` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.custom_targeting_key_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:CustomTargetingKeyService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the CustomTargetingKeyService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.custom_targeting_key_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the CustomTargetingKeyService service,
      # or if the versioned client gem needs an update to support the CustomTargetingKeyService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.custom_targeting_key_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :CustomTargetingKeyService
        service_module = service_module.const_get :CustomTargetingKeyService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for CustomTargetingValueService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::CustomTargetingValueService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/CustomTargetingValueService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the CustomTargetingValueService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the CustomTargetingValueService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.custom_targeting_value_service_available?}.
      #
      # ## About CustomTargetingValueService
      #
      # Provides methods for handling `CustomTargetingValue` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.custom_targeting_value_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:CustomTargetingValueService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the CustomTargetingValueService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.custom_targeting_value_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the CustomTargetingValueService service,
      # or if the versioned client gem needs an update to support the CustomTargetingValueService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.custom_targeting_value_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :CustomTargetingValueService
        service_module = service_module.const_get :CustomTargetingValueService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for DeviceCapabilityService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::DeviceCapabilityService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/DeviceCapabilityService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the DeviceCapabilityService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the DeviceCapabilityService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.device_capability_service_available?}.
      #
      # ## About DeviceCapabilityService
      #
      # Provides methods for handling `DeviceCapability` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.device_capability_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:DeviceCapabilityService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the DeviceCapabilityService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.device_capability_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the DeviceCapabilityService service,
      # or if the versioned client gem needs an update to support the DeviceCapabilityService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.device_capability_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :DeviceCapabilityService
        service_module = service_module.const_get :DeviceCapabilityService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for DeviceCategoryService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::DeviceCategoryService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/DeviceCategoryService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the DeviceCategoryService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the DeviceCategoryService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.device_category_service_available?}.
      #
      # ## About DeviceCategoryService
      #
      # Provides methods for handling `DeviceCategory` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.device_category_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:DeviceCategoryService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the DeviceCategoryService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.device_category_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the DeviceCategoryService service,
      # or if the versioned client gem needs an update to support the DeviceCategoryService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.device_category_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :DeviceCategoryService
        service_module = service_module.const_get :DeviceCategoryService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for DeviceManufacturerService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::DeviceManufacturerService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/DeviceManufacturerService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the DeviceManufacturerService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the DeviceManufacturerService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.device_manufacturer_service_available?}.
      #
      # ## About DeviceManufacturerService
      #
      # Provides methods for handling `DeviceManufacturer` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.device_manufacturer_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:DeviceManufacturerService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the DeviceManufacturerService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.device_manufacturer_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the DeviceManufacturerService service,
      # or if the versioned client gem needs an update to support the DeviceManufacturerService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.device_manufacturer_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :DeviceManufacturerService
        service_module = service_module.const_get :DeviceManufacturerService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for EntitySignalsMappingService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::EntitySignalsMappingService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/EntitySignalsMappingService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the EntitySignalsMappingService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the EntitySignalsMappingService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.entity_signals_mapping_service_available?}.
      #
      # ## About EntitySignalsMappingService
      #
      # Provides methods for handling `EntitySignalsMapping` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.entity_signals_mapping_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:EntitySignalsMappingService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the EntitySignalsMappingService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.entity_signals_mapping_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the EntitySignalsMappingService service,
      # or if the versioned client gem needs an update to support the EntitySignalsMappingService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.entity_signals_mapping_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :EntitySignalsMappingService
        service_module = service_module.const_get :EntitySignalsMappingService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for GeoTargetService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::GeoTargetService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/GeoTargetService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the GeoTargetService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the GeoTargetService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.geo_target_service_available?}.
      #
      # ## About GeoTargetService
      #
      # Provides methods for handling `GeoTarget` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.geo_target_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:GeoTargetService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the GeoTargetService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.geo_target_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the GeoTargetService service,
      # or if the versioned client gem needs an update to support the GeoTargetService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.geo_target_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :GeoTargetService
        service_module = service_module.const_get :GeoTargetService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for LineItemService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::LineItemService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/LineItemService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the LineItemService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the LineItemService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.line_item_service_available?}.
      #
      # ## About LineItemService
      #
      # Provides methods for handling `LineItem` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.line_item_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:LineItemService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the LineItemService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.line_item_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the LineItemService service,
      # or if the versioned client gem needs an update to support the LineItemService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.line_item_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :LineItemService
        service_module = service_module.const_get :LineItemService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for MobileCarrierService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::MobileCarrierService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/MobileCarrierService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the MobileCarrierService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the MobileCarrierService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.mobile_carrier_service_available?}.
      #
      # ## About MobileCarrierService
      #
      # Provides methods for handling `MobileCarrier` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.mobile_carrier_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:MobileCarrierService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the MobileCarrierService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.mobile_carrier_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the MobileCarrierService service,
      # or if the versioned client gem needs an update to support the MobileCarrierService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.mobile_carrier_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :MobileCarrierService
        service_module = service_module.const_get :MobileCarrierService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for MobileDeviceService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::MobileDeviceService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/MobileDeviceService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the MobileDeviceService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the MobileDeviceService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.mobile_device_service_available?}.
      #
      # ## About MobileDeviceService
      #
      # Provides methods for handling `MobileDevice` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.mobile_device_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:MobileDeviceService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the MobileDeviceService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.mobile_device_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the MobileDeviceService service,
      # or if the versioned client gem needs an update to support the MobileDeviceService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.mobile_device_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :MobileDeviceService
        service_module = service_module.const_get :MobileDeviceService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for MobileDeviceSubmodelService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::MobileDeviceSubmodelService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/MobileDeviceSubmodelService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the MobileDeviceSubmodelService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the MobileDeviceSubmodelService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.mobile_device_submodel_service_available?}.
      #
      # ## About MobileDeviceSubmodelService
      #
      # Provides methods for handling `MobileDeviceSubmodel` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.mobile_device_submodel_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:MobileDeviceSubmodelService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the MobileDeviceSubmodelService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.mobile_device_submodel_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the MobileDeviceSubmodelService service,
      # or if the versioned client gem needs an update to support the MobileDeviceSubmodelService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.mobile_device_submodel_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :MobileDeviceSubmodelService
        service_module = service_module.const_get :MobileDeviceSubmodelService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for NetworkService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::NetworkService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/NetworkService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the NetworkService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the NetworkService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.network_service_available?}.
      #
      # ## About NetworkService
      #
      # Provides methods for handling `Network` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.network_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:NetworkService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the NetworkService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.network_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the NetworkService service,
      # or if the versioned client gem needs an update to support the NetworkService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.network_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :NetworkService
        service_module = service_module.const_get :NetworkService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for OperatingSystemService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::OperatingSystemService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/OperatingSystemService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the OperatingSystemService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the OperatingSystemService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.operating_system_service_available?}.
      #
      # ## About OperatingSystemService
      #
      # Provides methods for handling `OperatingSystem` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.operating_system_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:OperatingSystemService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the OperatingSystemService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.operating_system_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the OperatingSystemService service,
      # or if the versioned client gem needs an update to support the OperatingSystemService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.operating_system_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :OperatingSystemService
        service_module = service_module.const_get :OperatingSystemService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for OperatingSystemVersionService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::OperatingSystemVersionService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/OperatingSystemVersionService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the OperatingSystemVersionService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the OperatingSystemVersionService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.operating_system_version_service_available?}.
      #
      # ## About OperatingSystemVersionService
      #
      # Provides methods for handling `OperatingSystemVersion` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.operating_system_version_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:OperatingSystemVersionService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the OperatingSystemVersionService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.operating_system_version_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the OperatingSystemVersionService service,
      # or if the versioned client gem needs an update to support the OperatingSystemVersionService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.operating_system_version_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :OperatingSystemVersionService
        service_module = service_module.const_get :OperatingSystemVersionService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for OrderService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::OrderService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/OrderService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the OrderService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the OrderService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.order_service_available?}.
      #
      # ## About OrderService
      #
      # Provides methods for handling `Order` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.order_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:OrderService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the OrderService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.order_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the OrderService service,
      # or if the versioned client gem needs an update to support the OrderService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.order_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :OrderService
        service_module = service_module.const_get :OrderService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for PlacementService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::PlacementService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/PlacementService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the PlacementService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the PlacementService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.placement_service_available?}.
      #
      # ## About PlacementService
      #
      # Provides methods for handling `Placement` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.placement_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:PlacementService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the PlacementService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.placement_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the PlacementService service,
      # or if the versioned client gem needs an update to support the PlacementService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.placement_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :PlacementService
        service_module = service_module.const_get :PlacementService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for PrivateAuctionDealService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::PrivateAuctionDealService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/PrivateAuctionDealService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the PrivateAuctionDealService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the PrivateAuctionDealService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.private_auction_deal_service_available?}.
      #
      # ## About PrivateAuctionDealService
      #
      # Provides methods for handling `PrivateAuctionDeal` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.private_auction_deal_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:PrivateAuctionDealService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the PrivateAuctionDealService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.private_auction_deal_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the PrivateAuctionDealService service,
      # or if the versioned client gem needs an update to support the PrivateAuctionDealService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.private_auction_deal_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :PrivateAuctionDealService
        service_module = service_module.const_get :PrivateAuctionDealService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for PrivateAuctionService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::PrivateAuctionService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/PrivateAuctionService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the PrivateAuctionService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the PrivateAuctionService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.private_auction_service_available?}.
      #
      # ## About PrivateAuctionService
      #
      # Provides methods for handling `PrivateAuction` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.private_auction_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:PrivateAuctionService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the PrivateAuctionService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.private_auction_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the PrivateAuctionService service,
      # or if the versioned client gem needs an update to support the PrivateAuctionService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.private_auction_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :PrivateAuctionService
        service_module = service_module.const_get :PrivateAuctionService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ProgrammaticBuyerService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::ProgrammaticBuyerService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/ProgrammaticBuyerService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ProgrammaticBuyerService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the ProgrammaticBuyerService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.programmatic_buyer_service_available?}.
      #
      # ## About ProgrammaticBuyerService
      #
      # Provides methods for handling `ProgrammaticBuyer` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.programmatic_buyer_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:ProgrammaticBuyerService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ProgrammaticBuyerService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.programmatic_buyer_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ProgrammaticBuyerService service,
      # or if the versioned client gem needs an update to support the ProgrammaticBuyerService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.programmatic_buyer_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :ProgrammaticBuyerService
        service_module = service_module.const_get :ProgrammaticBuyerService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ReportService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::ReportService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/ReportService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ReportService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the ReportService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.report_service_available?}.
      #
      # ## About ReportService
      #
      # Provides methods for interacting with reports.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.report_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:ReportService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ReportService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.report_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ReportService service,
      # or if the versioned client gem needs an update to support the ReportService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.report_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :ReportService
        service_module = service_module.const_get :ReportService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for RoleService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::RoleService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/RoleService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the RoleService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the RoleService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.role_service_available?}.
      #
      # ## About RoleService
      #
      # Provides methods for handling `Role` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.role_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:RoleService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the RoleService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.role_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the RoleService service,
      # or if the versioned client gem needs an update to support the RoleService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.role_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :RoleService
        service_module = service_module.const_get :RoleService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for SiteService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::SiteService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/SiteService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the SiteService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the SiteService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.site_service_available?}.
      #
      # ## About SiteService
      #
      # Provides methods for handling `Site` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.site_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:SiteService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the SiteService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.site_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the SiteService service,
      # or if the versioned client gem needs an update to support the SiteService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.site_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :SiteService
        service_module = service_module.const_get :SiteService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for TaxonomyCategoryService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::TaxonomyCategoryService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/TaxonomyCategoryService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the TaxonomyCategoryService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the TaxonomyCategoryService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.taxonomy_category_service_available?}.
      #
      # ## About TaxonomyCategoryService
      #
      # Provides methods for handling `TaxonomyCategory` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.taxonomy_category_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:TaxonomyCategoryService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the TaxonomyCategoryService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.taxonomy_category_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the TaxonomyCategoryService service,
      # or if the versioned client gem needs an update to support the TaxonomyCategoryService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.taxonomy_category_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :TaxonomyCategoryService
        service_module = service_module.const_get :TaxonomyCategoryService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for TeamService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::TeamService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/TeamService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the TeamService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the TeamService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.team_service_available?}.
      #
      # ## About TeamService
      #
      # Provides methods for handling `Team` objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.team_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:TeamService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the TeamService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.team_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the TeamService service,
      # or if the versioned client gem needs an update to support the TeamService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.team_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :TeamService
        service_module = service_module.const_get :TeamService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for UserService.
      #
      # By default, this returns an instance of
      # [Google::Ads::AdManager::V1::UserService::Rest::Client](https://rubydoc.info/gems/google-ads-ad_manager-v1/Google/Ads/AdManager/V1/UserService/Rest/Client)
      # for a REST client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the UserService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the UserService service.
      # You can determine whether the method will succeed by calling
      # {Google::Ads::AdManager.user_service_available?}.
      #
      # ## About UserService
      #
      # Provides methods for handling User objects.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.user_service version: :v1, &block
        require "google/ads/ad_manager/#{version.to_s.downcase}"

        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Ads::AdManager.const_get(package_name).const_get(:UserService)
        service_module.const_get(:Rest).const_get(:Client).new(&block)
      end

      ##
      # Determines whether the UserService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Ads::AdManager.user_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the UserService service,
      # or if the versioned client gem needs an update to support the UserService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.user_service_available? version: :v1
        require "google/ads/ad_manager/#{version.to_s.downcase}"
        package_name = Google::Ads::AdManager
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Ads::AdManager.const_get package_name
        return false unless service_module.const_defined? :UserService
        service_module = service_module.const_get :UserService
        return false unless service_module.const_defined? :Rest
        service_module = service_module.const_get :Rest
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end
    end
  end
end

helper_path = ::File.join __dir__, "ad_manager", "helpers.rb"
require "google/ads/ad_manager/helpers" if ::File.file? helper_path
