# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # The User resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the User.
        #     Format: `networks/{network_code}/users/{user_id}`
        # @!attribute [r] user_id
        #   @return [::Integer]
        #     Output only. `User` ID.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The name of the User. It has a maximum length of 128 characters.
        # @!attribute [rw] email
        #   @return [::String]
        #     Required. The email or login of the User. In order to create a new user,
        #     you must already have a Google Account.
        # @!attribute [rw] role
        #   @return [::String]
        #     Required. The unique Role ID of the User. Roles that are created by Google
        #     will have negative IDs.
        # @!attribute [r] active
        #   @return [::Boolean]
        #     Output only. Specifies whether or not the User is active. An inactive user
        #     cannot log in to the system or perform any operations.
        # @!attribute [rw] external_id
        #   @return [::String]
        #     Optional. An identifier for the User that is meaningful to the publisher.
        #     This attribute has a maximum length of 255 characters.
        # @!attribute [r] service_account
        #   @return [::Boolean]
        #     Output only. Whether the user is an OAuth2 service account user.
        #     Service account users can only be added through the UI.
        # @!attribute [rw] orders_ui_local_time_zone
        #   @return [::String]
        #     Optional. The IANA Time Zone Database time zone, e.g. "America/New_York",
        #     used in the orders and line items UI for this User. If not provided, the UI
        #     then defaults to using the Network's timezone. This setting only affects
        #     the UI for this user and does not affect the timezone of any dates and
        #     times returned in API responses.
        class User
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
