# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Request object for `GetTeam` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Team.
        #     Format: `networks/{network_code}/teams/{team_id}`
        class GetTeamRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `ListTeams` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of Teams.
        #     Format: `networks/{network_code}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of `Teams` to return. The service may return
        #     fewer than this value. If unspecified, at most 50 `Teams` will be returned.
        #     The maximum value is 1000; values greater than 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListTeams` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListTeams` must match
        #     the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Expression to filter the response.
        #     See syntax details at
        #     https://developers.google.com/ad-manager/api/beta/filters
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Expression to specify sorting order.
        #     See syntax details at
        #     https://developers.google.com/ad-manager/api/beta/filters#order
        # @!attribute [rw] skip
        #   @return [::Integer]
        #     Optional. Number of individual resources to skip while paginating.
        class ListTeamsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `ListTeamsRequest` containing matching `Team` objects.
        # @!attribute [rw] teams
        #   @return [::Array<::Google::Ads::AdManager::V1::Team>]
        #     The `Team` objects from the specified network.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     Total number of `Team` objects.
        #     If a filter was included in the request, this reflects the total number
        #     after the filtering is applied.
        #
        #     `total_size` won't be calculated in the response unless it has been
        #     included in a response field mask. The response field mask can be provided
        #     to the method by using the URL parameter `$fields` or `fields`, or by using
        #     the HTTP/gRPC header `X-Goog-FieldMask`.
        #
        #     For more information, see
        #     https://developers.google.com/ad-manager/api/beta/field-masks
        class ListTeamsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `CreateTeam` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this `Team` will be created.
        #     Format: `networks/{network_code}`
        # @!attribute [rw] team
        #   @return [::Google::Ads::AdManager::V1::Team]
        #     Required. The `Team` to create.
        class CreateTeamRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `BatchCreateTeams` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where `Teams` will be created.
        #     Format: `networks/{network_code}`
        #     The parent field in the CreateTeamRequest must match this
        #     field.
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Ads::AdManager::V1::CreateTeamRequest>]
        #     Required. The `Team` objects to create.
        #     A maximum of 100 objects can be created in a batch.
        class BatchCreateTeamsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchCreateTeams` method.
        # @!attribute [rw] teams
        #   @return [::Array<::Google::Ads::AdManager::V1::Team>]
        #     The `Team` objects created.
        class BatchCreateTeamsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `UpdateTeam` method.
        # @!attribute [rw] team
        #   @return [::Google::Ads::AdManager::V1::Team]
        #     Required. The `Team` to update.
        #
        #     The `Team`'s `name` is used to identify the `Team` to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateTeamRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `BatchUpdateTeams` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where `Teams` will be updated.
        #     Format: `networks/{network_code}`
        #     The parent field in the UpdateTeamRequest must match this
        #     field.
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Ads::AdManager::V1::UpdateTeamRequest>]
        #     Required. The `Team` objects to update.
        #     A maximum of 100 objects can be updated in a batch.
        class BatchUpdateTeamsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchUpdateTeams` method.
        # @!attribute [rw] teams
        #   @return [::Array<::Google::Ads::AdManager::V1::Team>]
        #     The `Team` objects updated.
        class BatchUpdateTeamsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `BatchActivateTeams` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Format: `networks/{network_code}`
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. The resource names of the `Team`s to activate.
        #     Format: `networks/{network_code}/teams/{team_id}`
        class BatchActivateTeamsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchActivateTeams` method.
        class BatchActivateTeamsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `BatchDeactivateTeams` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Format: `networks/{network_code}`
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. The resource names of the `Team`s to deactivate.
        #     Format: `networks/{network_code}/teams/{team_id}`
        class BatchDeactivateTeamsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchDeactivateTeams` method.
        class BatchDeactivateTeamsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
