# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # The `TaxonomyCategory` resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the `TaxonomyCategory`.
        #     Format: `networks/{network_code}/taxonomyCategories/{taxonomy_category_id}`
        # @!attribute [r] taxonomy_category_id
        #   @return [::Integer]
        #     Output only. `TaxonomyCategory` ID.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. Display name of the `TaxonomyCategory`.
        # @!attribute [r] grouping_only
        #   @return [::Boolean]
        #     Output only. Whether this `TaxonomyCategory` only serves to group its
        #     children.
        # @!attribute [r] parent_taxonomy_category_id
        #   @return [::Integer]
        #     Output only. The ID of the parent category this `TaxonomyCategory` descends
        #     from.
        # @!attribute [r] taxonomy_type
        #   @return [::Google::Ads::AdManager::V1::TaxonomyTypeEnum::TaxonomyType]
        #     Output only. The taxonomy that this `TaxonomyCategory` belongs to.
        # @!attribute [r] ancestor_names
        #   @return [::Array<::String>]
        #     Output only. The list of names of the ancestors of this `TaxonomyCategory`.
        # @!attribute [r] ancestor_taxonomy_category_ids
        #   @return [::Array<::Integer>]
        #     Output only. The list of IDs of the ancestors of this `TaxonomyCategory`.
        class TaxonomyCategory
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
