# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Targeting expression.
        # @!attribute [rw] geo_targeting
        #   @return [::Google::Ads::AdManager::V1::GeoTargeting]
        #     Optional. Used to target/exclude various geo targets.
        # @!attribute [rw] technology_targeting
        #   @return [::Google::Ads::AdManager::V1::TechnologyTargeting]
        #     Optional. Used to target various technology targeting dimensions.
        # @!attribute [rw] inventory_targeting
        #   @return [::Google::Ads::AdManager::V1::InventoryTargeting]
        #     Optional. Used to target/exclude various ad units and/or placements.
        # @!attribute [rw] request_platform_targeting
        #   @return [::Google::Ads::AdManager::V1::RequestPlatformTargeting]
        #     Optional. Used to target specific request platforms.
        # @!attribute [rw] custom_targeting
        #   @return [::Google::Ads::AdManager::V1::CustomTargeting]
        #     Optional. Used to target key/values, audience segments, and/or CMS
        #     metadata.
        # @!attribute [rw] user_domain_targeting
        #   @return [::Google::Ads::AdManager::V1::UserDomainTargeting]
        #     Optional. Used to target user domains.
        # @!attribute [rw] video_position_targeting
        #   @return [::Google::Ads::AdManager::V1::VideoPositionTargeting]
        #     Optional. Used to target video positions.
        # @!attribute [rw] data_segment_targeting
        #   @return [::Google::Ads::AdManager::V1::DataSegmentTargeting]
        #     Optional. Used to target data segments.
        # @!attribute [rw] content_targeting
        #   @return [::Google::Ads::AdManager::V1::ContentTargeting]
        #     Optional. Used to target content.
        # @!attribute [rw] mobile_application_targeting
        #   @return [::Google::Ads::AdManager::V1::MobileApplicationTargeting]
        #     Optional. Used to target mobile applications.
        class Targeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a list of targeted and excluded geos.
        # @!attribute [rw] targeted_geos
        #   @return [::Array<::String>]
        #     Optional. A list of geo resource names that should be targeted/included.
        # @!attribute [rw] excluded_geos
        #   @return [::Array<::String>]
        #     Optional. A list of geo resource names that should be excluded.
        class GeoTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Various types of technology targeting expressed by child messages are
        # applied with logical AND.
        # @!attribute [rw] bandwidth_targeting
        #   @return [::Google::Ads::AdManager::V1::BandwidthTargeting]
        #     Optional. Bandwidth targeting dimension.
        # @!attribute [rw] browser_targeting
        #   @return [::Google::Ads::AdManager::V1::BrowserTargeting]
        #     Optional. Browser targeting dimension.
        # @!attribute [rw] browser_language_targeting
        #   @return [::Google::Ads::AdManager::V1::BrowserLanguageTargeting]
        #     Optional. Browser language targeting dimension.
        # @!attribute [rw] device_capability_targeting
        #   @return [::Google::Ads::AdManager::V1::DeviceCapabilityTargeting]
        #     Optional. Device capability targeting dimension.
        # @!attribute [rw] device_category_targeting
        #   @return [::Google::Ads::AdManager::V1::DeviceCategoryTargeting]
        #     Optional. Device category targeting dimension.
        # @!attribute [rw] device_manufacturer_targeting
        #   @return [::Google::Ads::AdManager::V1::DeviceManufacturerTargeting]
        #     Optional. Device manufacturer targeting dimension.
        # @!attribute [rw] mobile_carrier_targeting
        #   @return [::Google::Ads::AdManager::V1::MobileCarrierTargeting]
        #     Optional. Mobile carrier targeting dimension.
        # @!attribute [rw] operating_system_targeting
        #   @return [::Google::Ads::AdManager::V1::OperatingSystemTargeting]
        #     Optional. Operating system targeting dimension.
        class TechnologyTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Bandwidth Targeting.
        #
        # Reach users accessing the internet via various means of connection, such as
        # cable, DSL, or dial-up. Can be useful to target campaigns using
        # low-resolution creatives or text ads for users with low bandwidth.
        # @!attribute [rw] targeted_bandwidth_groups
        #   @return [::Array<::String>]
        #     Optional. A list of resource names of the bandwidth groups that should be
        #     targeted/included.
        # @!attribute [rw] excluded_bandwidth_groups
        #   @return [::Array<::String>]
        #     Optional. A list of resource names of the bandwidth groups that should be
        #     excluded.
        class BandwidthTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Browser Targeting.
        #
        # Allows publishers to target/exclude a browser type (e.g. Chrome, Firefox,
        # Safari). For more information, see
        # https://support.google.com/admanager/answer/2884033 (Targeting types >
        # Browser).
        # @!attribute [rw] targeted_browsers
        #   @return [::Array<::String>]
        #     Optional. A list of browser resource names that should be
        #     targeted/included.
        # @!attribute [rw] excluded_browsers
        #   @return [::Array<::String>]
        #     Optional. A list of browser resource names that should be excluded.
        class BrowserTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Browser Language Targeting.
        #
        # For ads targeting mobile apps and their associated WebViews, the language
        # used is based on the language specified by the user in their mobile device
        # settings. If a browser has more than one language assigned to it, each
        # language generates an impression.
        # @!attribute [rw] targeted_browser_languages
        #   @return [::Array<::String>]
        #     Optional. A list of browser language resource names that should be
        #     targeted/included.
        # @!attribute [rw] excluded_browser_languages
        #   @return [::Array<::String>]
        #     Optional. A list of browser language resource names that should be
        #     excluded.
        class BrowserLanguageTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a list of targeted and excluded device categories.
        # @!attribute [rw] targeted_categories
        #   @return [::Array<::String>]
        #     Optional. A list of device category resource names that should be
        #     targeted/included.
        # @!attribute [rw] excluded_categories
        #   @return [::Array<::String>]
        #     Optional. A list of device category resource names that should be excluded.
        class DeviceCategoryTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Device Capability Targeting.
        #
        # Can be used to target/exclude users using mobile apps, ad requests resulting
        # from apps built on the MRAID standard, or users on devices that are able to
        # make phone calls versus devices that aren't able to make phone calls, such as
        # tablets.
        # @!attribute [rw] targeted_capabilities
        #   @return [::Array<::String>]
        #     Optional. A list of device capability resource names that should be
        #     targeted/included.
        # @!attribute [rw] excluded_capabilities
        #   @return [::Array<::String>]
        #     Optional. A list of device capability resource names that should be
        #     excluded.
        class DeviceCapabilityTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Device Manufacturer Targeting.
        #
        # Can be used to target/exclude users on devices made by specific brands or
        # companies, such as Apple, Google, Samsung and others. For more information,
        # see https://support.google.com/admanager/answer/2884033 ("Targeting types >
        # Device manufacturer").
        # @!attribute [rw] targeted_device_manufacturers
        #   @return [::Array<::String>]
        #     Optional. A list of device manufacturer resource names that should be
        #     targeted/included.
        # @!attribute [rw] excluded_device_manufacturers
        #   @return [::Array<::String>]
        #     Optional. A list of device manufacturer resource names that should be
        #     excluded.
        # @!attribute [rw] targeted_mobile_devices
        #   @return [::Array<::String>]
        #     Optional. A list of mobile device resource names that should be
        #     targeted/included.
        # @!attribute [rw] excluded_mobile_devices
        #   @return [::Array<::String>]
        #     Optional. A list of mobile device resource names that should be excluded.
        # @!attribute [rw] targeted_mobile_device_submodels
        #   @return [::Array<::String>]
        #     Optional. A list of mobile device submodel resource names that should be
        #     targeted/included.
        # @!attribute [rw] excluded_mobile_device_submodels
        #   @return [::Array<::String>]
        #     Optional. A list of mobile device submodel resource names that should be
        #     excluded.
        class DeviceManufacturerTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Mobile Carrier Targeting.
        #
        # Can be used to target/exclude a variety of mobile carriers, such as AT&T,
        # Verizon, or T-Mobile.
        # @!attribute [rw] targeted_mobile_carriers
        #   @return [::Array<::String>]
        #     Optional. A list of mobile carrier resource names that should be
        #     targeted/included.
        # @!attribute [rw] excluded_mobile_carriers
        #   @return [::Array<::String>]
        #     Optional. A list of mobile carrier resource names that should be excluded.
        class MobileCarrierTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Operating System Targeting
        # @!attribute [rw] targeted_operating_systems
        #   @return [::Array<::String>]
        #     Optional. A list of operating system resource names that should be
        #     targeted/included.
        # @!attribute [rw] excluded_operating_systems
        #   @return [::Array<::String>]
        #     Optional. A list of operating system resource names that should be
        #     excluded.
        # @!attribute [rw] targeted_operating_system_versions
        #   @return [::Array<::String>]
        #     Optional. A list of operating system version resource names that should be
        #     targeted/included.
        # @!attribute [rw] excluded_operating_system_versions
        #   @return [::Array<::String>]
        #     Optional. A list of operating system version resource names that should be
        #     excluded.
        class OperatingSystemTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Targeted ad units and AU placements are applied with
        # logical OR. Example:
        #
        #  (au:1 OR au:2 OR au_placement:5) AND (NOT (au:3))
        # @!attribute [rw] targeted_ad_units
        #   @return [::Array<::Google::Ads::AdManager::V1::AdUnitTargeting>]
        #     Optional. A list of ad units that should be targeted/included.
        # @!attribute [rw] excluded_ad_units
        #   @return [::Array<::Google::Ads::AdManager::V1::AdUnitTargeting>]
        #     Optional. A list of ad units that should be excluded.
        #
        #     Excluded AUs take precedence over targeted AUs. In fact an AU can be
        #     excluded only if one of its ancestors is targeted. Subsequently child
        #     AUs of an excluded AU can not be targeted (except via a placement).
        # @!attribute [rw] targeted_placements
        #   @return [::Array<::String>]
        #     Optional. The resource names of the placements that should be
        #     targeted/included.
        class InventoryTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies an ad unit and (optionally) its descendants.
        # @!attribute [rw] include_descendants
        #   @return [::Boolean]
        #     Whether this ad unit's children should be targeted/excluded as well.
        # @!attribute [rw] ad_unit
        #   @return [::String]
        #     Optional. The resource name of this ad unit.
        class AdUnitTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a list of targeted request platforms.
        # @!attribute [rw] request_platforms
        #   @return [::Array<::Google::Ads::AdManager::V1::RequestPlatformEnum::RequestPlatform>]
        #     Optional. The list of request platforms that should be targeted.
        class RequestPlatformTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the top level targeting expression for custom key/values,
        # audience segments, and/or CMS metadata.
        # @!attribute [rw] custom_targeting_clauses
        #   @return [::Array<::Google::Ads::AdManager::V1::CustomTargetingClause>]
        #     Optional. These clauses are all ORed together.
        class CustomTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a logical AND of individual custom targeting expressions.
        # @!attribute [rw] custom_targeting_literals
        #   @return [::Array<::Google::Ads::AdManager::V1::CustomTargetingLiteral>]
        #     Optional. Leaf targeting expressions for custom key/values.
        # @!attribute [rw] audience_segment_targetings
        #   @return [::Array<::Google::Ads::AdManager::V1::AudienceSegmentTargeting>]
        #     Optional. Leaf targeting expressions for audience segments.
        # @!attribute [rw] cms_metadata_targetings
        #   @return [::Array<::Google::Ads::AdManager::V1::CmsMetadataTargeting>]
        #     Optional. Leaf targeting expressions for cms metadata.
        class CustomTargetingClause
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents targeting for custom key/values. The values are ORed together.
        # @!attribute [rw] negative
        #   @return [::Boolean]
        #     Whether this expression is negatively targeted, meaning it matches
        #     ad requests that exclude the below values.
        # @!attribute [rw] custom_targeting_key
        #   @return [::String]
        #     Optional. The resource name of the targeted CustomKey.
        # @!attribute [rw] custom_targeting_values
        #   @return [::Array<::String>]
        #     Optional. The resource names of the targeted CustomValues.
        class CustomTargetingLiteral
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents targeting for audience segments. The values are combined in a
        # logical `OR`.
        # @!attribute [rw] negative
        #   @return [::Boolean]
        #     Whether this expression is negatively targeted, meaning it matches
        #     ad requests that exclude the below values.
        # @!attribute [rw] audience_segments
        #   @return [::Array<::String>]
        #     Optional. The targeted audience segments.
        #
        #     This is either the resource name of a first-party audience segment or an
        #     alias to the effective third-party audience segment. Third-party audience
        #     segment resource names containing `~direct` or `~global` will be normalized
        #     by the server. For example, `networks/1234/audienceSegments/4567~direct`
        #     will be normalized to `networks/1234/audienceSegments/4567`.
        class AudienceSegmentTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents targeting for CMS metadata. The values are ORed together.
        # @!attribute [rw] negative
        #   @return [::Boolean]
        #     Whether this expression is negatively targeted, meaning it matches
        #     ad requests that exclude the below values.
        # @!attribute [rw] cms_metadata_values
        #   @return [::Array<::String>]
        #     Optional. The resource names of the targeted CMS metadata values.
        class CmsMetadataTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # User Domain Targeting
        # @!attribute [rw] targeted_user_domains
        #   @return [::Array<::String>]
        #     Optional. A list of user domains that should be targeted/included.
        # @!attribute [rw] excluded_user_domains
        #   @return [::Array<::String>]
        #     Optional. A list of user domains that should be excluded.
        class UserDomainTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Video Position Targeting
        # @!attribute [rw] video_positions
        #   @return [::Array<::Google::Ads::AdManager::V1::VideoPosition>]
        #     Optional. A list of video position targeting criterion (applied with a
        #     logical AND).
        class VideoPositionTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Video Position Targeting Criterion
        # @!attribute [rw] midroll_index
        #   @return [::Integer]
        #     Optional. The index of the mid-roll to target. This field is ignored when
        #     targeting any video position (e.g. position_type) other than MIDROLL.
        # @!attribute [rw] reverse_midroll_index
        #   @return [::Integer]
        #     Optional. The index from the back of the pod of the mid-roll to target.
        #     This field is ignored when targeting any video position (e.g.
        #     position_type) other than MIDROLL or if targeting a specific midroll index
        #     (e.g. midroll_index != 0).
        # @!attribute [rw] pod_position
        #   @return [::Integer]
        #     Optional. The video position within a pod to target. This field must be
        #     unset in order to target a specific video position (e.g. position_type),
        #     bumper type (e.g. bumper_type), or custom ad spot (e.g. custom_spot_id).
        # @!attribute [rw] position_type
        #   @return [::Google::Ads::AdManager::V1::VideoPositionEnum::VideoPosition]
        #     Optional. The position within a video to target. A video ad can target a
        #     position (pre-roll, all mid-rolls, or post-roll) or a specific mid-roll
        #     index.
        # @!attribute [rw] bumper_type
        #   @return [::Google::Ads::AdManager::V1::TargetedVideoBumperTypeEnum::TargetedVideoBumperType]
        #     Optional. The video bumper type to target. This field must be unset in
        #     order to target a specific video position (e.g. position_type), pod
        #     position (e.g. pod_position), or custom ad spot (e.g. custom_spot_id).
        class VideoPosition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Data Segment Targeting
        # @!attribute [r] has_data_segment_targeting
        #   @return [::Boolean]
        #     Output only. Whether any data segments are currently targeted.
        class DataSegmentTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Content Targeting
        #
        # Targeted/excluded content entities and bundles.
        # @!attribute [rw] targeted_content
        #   @return [::Array<::String>]
        #     Optional. The resource names of the
        #     {::Google::Ads::AdManager::V1::Content Content} that should be
        #     targeted/included.
        # @!attribute [rw] excluded_content
        #   @return [::Array<::String>]
        #     Optional. The resource names of the
        #     {::Google::Ads::AdManager::V1::Content Content} that should be
        #     excluded.
        # @!attribute [rw] targeted_content_bundles
        #   @return [::Array<::String>]
        #     Optional. The resource names of the
        #     {::Google::Ads::AdManager::V1::ContentBundle ContentBundles} that
        #     should be targeted/included.
        # @!attribute [rw] excluded_content_bundles
        #   @return [::Array<::String>]
        #     Optional. The resource names of the
        #     {::Google::Ads::AdManager::V1::ContentBundle ContentBundles} that
        #     should be excluded.
        class ContentTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Mobile Application Targeting
        # @!attribute [rw] first_party_targeting
        #   @return [::Google::Ads::AdManager::V1::FirstPartyMobileApplicationTargeting]
        #     Optional. The targeted/excluded first-party mobile applications.
        class MobileApplicationTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # First-party mobile application targeting.
        # @!attribute [rw] targeted_applications
        #   @return [::Array<::String>]
        #     Optional. The resource names of the first-party applications that should be
        #     targeted.
        # @!attribute [rw] excluded_applications
        #   @return [::Array<::String>]
        #     Optional. The resource names of the first-party applications that should be
        #     excluded.
        class FirstPartyMobileApplicationTargeting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
