# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Request object for `GetSite` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Site.
        #     Format: `networks/{network_code}/sites/{site_id}`
        class GetSiteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `ListSites` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of Sites.
        #     Format: `networks/{network_code}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of `Sites` to return. The service may return
        #     fewer than this value. If unspecified, at most 50 `Sites` will be returned.
        #     The maximum value is 1000; values greater than 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListSites` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListSites` must match
        #     the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Expression to filter the response.
        #     See syntax details at
        #     https://developers.google.com/ad-manager/api/beta/filters
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Expression to specify sorting order.
        #     See syntax details at
        #     https://developers.google.com/ad-manager/api/beta/filters#order
        # @!attribute [rw] skip
        #   @return [::Integer]
        #     Optional. Number of individual resources to skip while paginating.
        class ListSitesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `ListSitesRequest` containing matching `Site` objects.
        # @!attribute [rw] sites
        #   @return [::Array<::Google::Ads::AdManager::V1::Site>]
        #     The `Site` objects from the specified network.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     Total number of `Site` objects.
        #     If a filter was included in the request, this reflects the total number
        #     after the filtering is applied.
        #
        #     `total_size` won't be calculated in the response unless it has been
        #     included in a response field mask. The response field mask can be provided
        #     to the method by using the URL parameter `$fields` or `fields`, or by using
        #     the HTTP/gRPC header `X-Goog-FieldMask`.
        #
        #     For more information, see
        #     https://developers.google.com/ad-manager/api/beta/field-masks
        class ListSitesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `CreateSite` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this `Site` will be created.
        #     Format: `networks/{network_code}`
        # @!attribute [rw] site
        #   @return [::Google::Ads::AdManager::V1::Site]
        #     Required. The `Site` to create.
        class CreateSiteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `BatchCreateSites` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where `Sites` will be created.
        #     Format: `networks/{network_code}`
        #     The parent field in the CreateSiteRequest must match this
        #     field.
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Ads::AdManager::V1::CreateSiteRequest>]
        #     Required. The `Site` objects to create.
        #     A maximum of 100 objects can be created in a batch.
        class BatchCreateSitesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchCreateSites` method.
        # @!attribute [rw] sites
        #   @return [::Array<::Google::Ads::AdManager::V1::Site>]
        #     The `Site` objects created.
        class BatchCreateSitesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `UpdateSite` method.
        # @!attribute [rw] site
        #   @return [::Google::Ads::AdManager::V1::Site]
        #     Required. The `Site` to update.
        #
        #     The `Site`'s `name` is used to identify the `Site` to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateSiteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `BatchUpdateSites` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where `Sites` will be updated.
        #     Format: `networks/{network_code}`
        #     The parent field in the UpdateSiteRequest must match this
        #     field.
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Ads::AdManager::V1::UpdateSiteRequest>]
        #     Required. The `Site` objects to update.
        #     A maximum of 100 objects can be updated in a batch.
        class BatchUpdateSitesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchUpdateSites` method.
        # @!attribute [rw] sites
        #   @return [::Array<::Google::Ads::AdManager::V1::Site>]
        #     The `Site` objects updated.
        class BatchUpdateSitesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `BatchDeactivateSites` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Format: `networks/{network_code}`
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. The resource names of the `Site` objects to deactivate.
        class BatchDeactivateSitesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchDeactivateSites` method.
        class BatchDeactivateSitesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `BatchSubmitSitesForApproval` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Format: `networks/{network_code}`
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. The resource names of the `Site` objects to submit for approval.
        class BatchSubmitSitesForApprovalRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchSubmitSitesForApproval` method.
        class BatchSubmitSitesForApprovalResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
