# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # A Site represents a domain owned or represented by a network. For a parent
        # network managing other networks as part of Multiple Customer Management
        # "Manage Inventory" model, it could be the child's domain.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the `Site`.
        #     Format: `networks/{network_code}/sites/{site_id}`
        # @!attribute [rw] url
        #   @return [::String]
        #     Required. The URL of the Site.
        # @!attribute [rw] child_network_code
        #   @return [::String]
        #     Optional. The network code of the child if the Site is being managed for an
        #     MCM child network, or null if owned by this network.
        # @!attribute [r] approval_status
        #   @return [::Google::Ads::AdManager::V1::SiteApprovalStatusEnum::SiteApprovalStatus]
        #     Output only. Status of the review performed on the Site by Google.
        # @!attribute [r] approval_status_update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The latest Site approval status change time.
        # @!attribute [r] disapproval_reasons
        #   @return [::Array<::Google::Ads::AdManager::V1::DisapprovalReason>]
        #     Output only. Provides reasons for disapproving the Site. It is null when
        #     the Site is not disapproved.
        class Site
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the reason for which Google disapproved the Site.
        # @!attribute [r] type
        #   @return [::Google::Ads::AdManager::V1::SiteDisapprovalReasonEnum::SiteDisapprovalReason]
        #     Output only. The type of policy violation found for the Site.
        # @!attribute [r] details
        #   @return [::String]
        #     Output only. Additional details for the disapproval of the Site.
        class DisapprovalReason
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
