# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Wrapper message for
        # {::Google::Ads::AdManager::V1::SiteDisapprovalReasonEnum::SiteDisapprovalReason SiteDisapprovalReason}
        class SiteDisapprovalReasonEnum
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The list of possible policy violation types for a Site.
          module SiteDisapprovalReason
            # Default value. This value is unused.
            SITE_DISAPPROVAL_REASON_UNSPECIFIED = 0

            # The site has content that violates policy.
            CONTENT = 1

            # Generic error type.
            OTHER = 2

            # The parent must be an authorized seller of the child network's inventory.
            OWNERSHIP = 3
          end
        end

        # Wrapper message for
        # {::Google::Ads::AdManager::V1::SiteApprovalStatusEnum::SiteApprovalStatus SiteApprovalStatus}
        class SiteApprovalStatusEnum
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents the approval status of a site.
          module SiteApprovalStatus
            # Default value. This value is unused.
            SITE_APPROVAL_STATUS_UNSPECIFIED = 0

            # The site has been approved to serve ads.
            APPROVED = 1

            # The site has been disapproved from serving ads.
            DISAPPROVED = 2

            # The default status with which a site is created.
            DRAFT = 3

            # The site has been deactivated and is not serving ads due to dormancy. It
            # must be resubmitted for approval.
            REQUIRES_REVIEW = 4

            # Once the site is submitted for approval, its status changes from draft to
            # unchecked. It will be reviwed with an estimated turn-around time of 24h.
            # Such a site cannot serve ads.
            UNCHECKED = 5
          end
        end
      end
    end
  end
end
