# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Wrapper message for [RequestPlatform].
        #
        # Describes the platform from which a request is made and on which the ad is
        # rendered. In the event of multiple platforms, the platform that ultimately
        # renders the ad is the targeted platform. For example, a video player on a
        # website would have a request platform of `VIDEO_PLAYER`.
        class RequestPlatformEnum
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The different environments in which an ad can be shown.
          module RequestPlatform
            # No value specified
            REQUEST_PLATFORM_UNSPECIFIED = 0

            # Represents a request made from a web browser (incl. desktop browsers,
            # mobile browsers, webviews, etc.).
            BROWSER = 1

            # Represents a request made from a Mobile Application.
            MOBILE_APP = 2

            # Represents a request made from a video player.
            VIDEO_PLAYER = 3
          end
        end
      end
    end
  end
end
