# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Represents a single value in a report.
        # @!attribute [rw] int_value
        #   @return [::Integer]
        #     For integer values.
        #
        #     Note: The following fields are mutually exclusive: `int_value`, `double_value`, `string_value`, `bool_value`, `int_list_value`, `string_list_value`, `double_list_value`, `bytes_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] double_value
        #   @return [::Float]
        #     For double values.
        #
        #     Note: The following fields are mutually exclusive: `double_value`, `int_value`, `string_value`, `bool_value`, `int_list_value`, `string_list_value`, `double_list_value`, `bytes_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] string_value
        #   @return [::String]
        #     For string values.
        #
        #     Note: The following fields are mutually exclusive: `string_value`, `int_value`, `double_value`, `bool_value`, `int_list_value`, `string_list_value`, `double_list_value`, `bytes_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bool_value
        #   @return [::Boolean]
        #     For boolean values.
        #
        #     Note: The following fields are mutually exclusive: `bool_value`, `int_value`, `double_value`, `string_value`, `int_list_value`, `string_list_value`, `double_list_value`, `bytes_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] int_list_value
        #   @return [::Google::Ads::AdManager::V1::ReportValue::IntList]
        #     For lists of integer values.
        #
        #     Note: The following fields are mutually exclusive: `int_list_value`, `int_value`, `double_value`, `string_value`, `bool_value`, `string_list_value`, `double_list_value`, `bytes_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] string_list_value
        #   @return [::Google::Ads::AdManager::V1::ReportValue::StringList]
        #     For lists of string values.
        #
        #     Note: The following fields are mutually exclusive: `string_list_value`, `int_value`, `double_value`, `string_value`, `bool_value`, `int_list_value`, `double_list_value`, `bytes_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] double_list_value
        #   @return [::Google::Ads::AdManager::V1::ReportValue::DoubleList]
        #     For lists of double values.
        #
        #     Note: The following fields are mutually exclusive: `double_list_value`, `int_value`, `double_value`, `string_value`, `bool_value`, `int_list_value`, `string_list_value`, `bytes_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bytes_value
        #   @return [::String]
        #     For bytes values.
        #
        #     Note: The following fields are mutually exclusive: `bytes_value`, `int_value`, `double_value`, `string_value`, `bool_value`, `int_list_value`, `string_list_value`, `double_list_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ReportValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A list of integer values.
          # @!attribute [rw] values
          #   @return [::Array<::Integer>]
          #     The values
          class IntList
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A list of string values.
          # @!attribute [rw] values
          #   @return [::Array<::String>]
          #     The values
          class StringList
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A list of double values.
          # @!attribute [rw] values
          #   @return [::Array<::Float>]
          #     The values
          class DoubleList
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
