# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Request message for a running a report.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The report to run.
        #     Format: `networks/{network_code}/reports/{report_id}`
        class RunReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `RunReport` operation metadata.
        # @!attribute [rw] percent_complete
        #   @return [::Integer]
        #     An estimate of how close this report is to being completed. Will always be
        #     100 for failed and completed reports.
        # @!attribute [rw] report
        #   @return [::String]
        #     The result's parent report.
        class RunReportMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for a completed `RunReport` operation.
        # @!attribute [rw] report_result
        #   @return [::String]
        #     The unique name of the generated result. Use with `FetchReportResultRows`
        #     to retrieve data.
        class RunReportResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `GetReport` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the report.
        #     Format: `networks/{network_code}/reports/{report_id}`
        class GetReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `ListReports` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of reports.
        #     Format: `networks/{network_code}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of `Reports` to return. The service may return
        #     fewer than this value. If unspecified, at most 50 `Reports` will be
        #     returned. The maximum value is 1000; values greater than 1000 will be
        #     coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListReports` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListReports` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Expression to filter the response.
        #     See syntax details at
        #     https://developers.google.com/ad-manager/api/beta/filters
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Expression to specify sorting order.
        #     See syntax details at
        #     https://developers.google.com/ad-manager/api/beta/filters#order
        # @!attribute [rw] skip
        #   @return [::Integer]
        #     Optional. Number of individual resources to skip while paginating.
        class ListReportsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `ListReportsResponse` containing matching `Report`
        # objects.
        # @!attribute [rw] reports
        #   @return [::Array<::Google::Ads::AdManager::V1::Report>]
        #     The `Report` objects from the specified network.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     Total number of `Report` objects.
        #     If a filter was included in the request, this reflects the total number
        #     after the filtering is applied.
        #
        #     `total_size` won't be calculated in the response unless it has been
        #     included in a response field mask. The response field mask can be provided
        #     to the method by using the URL parameter `$fields` or `fields`, or by using
        #     the HTTP/gRPC header `X-Goog-FieldMask`.
        #
        #     For more information, see
        #     https://developers.google.com/ad-manager/api/beta/field-masks
        class ListReportsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `CreateReport` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this `Report` will be created.
        #     Format: `networks/{network_code}`
        # @!attribute [rw] report
        #   @return [::Google::Ads::AdManager::V1::Report]
        #     Required. The `Report` to create.
        class CreateReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `UpdateReport` method.
        # @!attribute [rw] report
        #   @return [::Google::Ads::AdManager::V1::Report]
        #     Required. The `Report` to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the fetch report result rows endpoint.
        # @!attribute [rw] name
        #   @return [::String]
        #     The report result being fetched.
        #     Format:
        #     `networks/{network_code}/reports/{report_id}/results/{report_result_id}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of rows to return. The service may return
        #     fewer than this value. If unspecified, at most 1,000 rows will be returned.
        #     The maximum value is 10,000; values greater than 10,000 will be reduced to
        #     10,000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `FetchReportResultRows`
        #     call. Provide this to retrieve the second and subsequent batches of rows.
        class FetchReportResultRowsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for the fetch report result rows endpoint.
        # @!attribute [rw] rows
        #   @return [::Array<::Google::Ads::AdManager::V1::ReportDataTable::Row>]
        #     Up to `page_size` rows of report data.
        # @!attribute [rw] run_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which the report was scheduled to run. For non-scheduled
        #     reports, this is the time at which the report was requested to be run.
        # @!attribute [rw] date_ranges
        #   @return [::Array<::Google::Ads::AdManager::V1::ReportDefinition::DateRange::FixedDateRange>]
        #     The computed fixed date ranges this report includes.
        #     Only returned with the first page of results (when page_token is not
        #     included in the request).
        # @!attribute [rw] comparison_date_ranges
        #   @return [::Array<::Google::Ads::AdManager::V1::ReportDefinition::DateRange::FixedDateRange>]
        #     The computed comparison fixed date ranges this report includes.
        #     Only returned with the first page of results (when page_token is not
        #     included in the request).
        # @!attribute [rw] total_row_count
        #   @return [::Integer]
        #     The total number of rows available from this report. Useful for
        #     pagination.
        #     Only returned with the first page of results (when page_token is not
        #     included in the request).
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class FetchReportResultRowsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
