# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # The `Report` resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the report.
        #     Report resource name have the form:
        #     `networks/{network_code}/reports/{report_id}`
        # @!attribute [r] report_id
        #   @return [::Integer]
        #     Output only. Report ID.
        # @!attribute [rw] visibility
        #   @return [::Google::Ads::AdManager::V1::Report::Visibility]
        #     Optional. The visibility of a report.
        # @!attribute [rw] report_definition
        #   @return [::Google::Ads::AdManager::V1::ReportDefinition]
        #     Required. The report definition of the report.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Display name for the report.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The instant this report was last modified.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The instant this report was created.
        # @!attribute [r] locale
        #   @return [::String]
        #     Output only. The locale of this report. Locale is set from the user's
        #     locale at the time of the request. Locale can't be modified.
        # @!attribute [rw] schedule_options
        #   @return [::Google::Ads::AdManager::V1::ScheduleOptions]
        #     Optional. The schedule options of this report.
        class Report
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The visibility of a report.
          module Visibility
            # Default value. Reports with hidden visibility won't appear in the Ad
            # Manager UI.
            HIDDEN = 0

            # Reports with draft visibility will appear in the Ad Manager UI only if
            # the user has configured the UI to show them.
            DRAFT = 1

            # Reports with saved visibility will appear in the Ad Manager UI by
            # default. Alias for VISIBLE and will be replaced in the future.
            SAVED = 2

            # Reports with this visibility will appear in the Ad Manager UI.
            VISIBLE = 2
          end
        end

        # A table containing report data including dimension and metric values.
        class ReportDataTable
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A row of report data.
          # @!attribute [rw] dimension_values
          #   @return [::Array<::Google::Ads::AdManager::V1::ReportValue>]
          #     The order of the dimension values is the same as the order of the
          #     dimensions specified in the request.
          # @!attribute [rw] metric_value_groups
          #   @return [::Array<::Google::Ads::AdManager::V1::ReportDataTable::MetricValueGroup>]
          #     The length of the metric_value_groups
          #     field will be equal to the length of the date_ranges field in the
          #     fetch response. The metric_value_groups field is
          #     ordered such that each index corresponds to the date_range at the same
          #     index. For example, given date_ranges [x, y], metric_value_groups will
          #     have a length of two. The first entry in metric_value_groups represents
          #     the metrics for date x and the second entry in metric_value_groups
          #     represents the metrics for date y.
          class Row
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Contains all metric values requested for a single date range and set of
          # column dimension values (returned in the columns field of the response).
          # The order of the metrics in each field corresponds to the order of the
          # metrics specified in the request.
          # @!attribute [rw] primary_values
          #   @return [::Array<::Google::Ads::AdManager::V1::ReportValue>]
          #     Data for the PRIMARY MetricValueType.
          # @!attribute [rw] primary_percent_of_total_values
          #   @return [::Array<::Google::Ads::AdManager::V1::ReportValue>]
          #     Data for the PRIMARY_PERCENT_OF_TOTAL MetricValueType.
          # @!attribute [rw] comparison_values
          #   @return [::Array<::Google::Ads::AdManager::V1::ReportValue>]
          #     Data for the COMPARISON MetricValueType.
          # @!attribute [rw] comparison_percent_of_total_values
          #   @return [::Array<::Google::Ads::AdManager::V1::ReportValue>]
          #     Data for the COMPARISON_PERCENT_OF_TOTAL MetricValueType.
          # @!attribute [rw] absolute_change_values
          #   @return [::Array<::Google::Ads::AdManager::V1::ReportValue>]
          #     Data for the ABSOLUTE_CHANGE MetricValueType.
          # @!attribute [rw] relative_change_values
          #   @return [::Array<::Google::Ads::AdManager::V1::ReportValue>]
          #     Data for the RELATIVE_CHANGE MetricValueType.
          # @!attribute [rw] flag_values
          #   @return [::Array<::Boolean>]
          #     If true, the flag's conditions are met. If false, the flag's
          #     conditions are not met. flag_values has the same length as
          #     flags and index i of flag_values represents the flag at index i
          #     of flags.
          class MetricValueGroup
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The options for a scheduled report.
        # @!attribute [rw] schedule
        #   @return [::Google::Ads::AdManager::V1::ScheduleOptions::Schedule]
        #     Information pertaining to schedule itself.
        # @!attribute [rw] delivery_condition
        #   @return [::Google::Ads::AdManager::V1::ScheduleOptions::DeliveryCondition]
        #     Option for when to deliver the scheduled report.
        # @!attribute [rw] flags
        #   @return [::Array<::Google::Ads::AdManager::V1::ReportDefinition::Flag>]
        #     Optional. The flags evaluated when ReportDeliveryOption.WHEN_FLAG_PRESENT
        #     is specified.
        class ScheduleOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The schedule for the report
          # @!attribute [rw] weekly_schedule
          #   @return [::Google::Ads::AdManager::V1::ScheduleOptions::Schedule::WeeklySchedule]
          #     Days of week to schedule report run.
          #
          #     Note: The following fields are mutually exclusive: `weekly_schedule`, `monthly_schedule`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] monthly_schedule
          #   @return [::Google::Ads::AdManager::V1::ScheduleOptions::Schedule::MonthlySchedule]
          #     Days of month to schedule report run.
          #
          #     Note: The following fields are mutually exclusive: `monthly_schedule`, `weekly_schedule`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] start_date
          #   @return [::Google::Type::Date]
          #     Date for the first run of the report.
          # @!attribute [rw] end_date
          #   @return [::Google::Type::Date]
          #     Date for the final run of the report.
          # @!attribute [rw] frequency
          #   @return [::Google::Ads::AdManager::V1::ScheduleOptions::Schedule::Frequency]
          #     Frequency to run report.
          # @!attribute [rw] start_time
          #   @return [::Google::Type::TimeOfDay]
          #     Indicates start time for schedule to run
          #     Will use the time_zone from `ReportDefinition`. Defaults
          #     to the publisher's time zone if not specified.
          #
          #     For HOURLY, TWO_TIMES_DAILY, THREE_TIMES_DAILY, or FOUR_TIMES_DAILY, this
          #     will be the time of day that the first report will run on the first day.
          #     For example, if the start time is 2:00 PM, and the frequency is
          #     THREE_TIMES_DAILY, the first day will have reports scheduled at 2:00 PM,
          #     10:00 PM. Each subsequent day will have reports scheduled at 6:00 AM,
          #     2:00 PM, 10:00 PM.
          class Schedule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Days of week to schedule report run.
            # @!attribute [rw] weekly_scheduled_days
            #   @return [::Array<::Google::Type::DayOfWeek>]
            #     Specifies days of the week on which to run report.
            class WeeklySchedule
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Days of Month to schedule report run.
            # @!attribute [rw] monthly_scheduled_days
            #   @return [::Array<::Integer>]
            #     Specifies days of the month to run report. Range is from 1-31.
            #     Will ignore days that are not valid for the given month.
            class MonthlySchedule
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Frequency to run report.
            module Frequency
              # No Frequency specified.
              FREQUENCY_UNSPECIFIED = 0

              # Schedule report to run every hour.
              HOURLY = 1

              # Schedule report to run twice a day (every 12 hours).
              TWO_TIMES_DAILY = 2

              # Schedule report to run three times a day (every 8 hours).
              THREE_TIMES_DAILY = 3

              # Schedule report to run four times a day (every 6 hours).
              FOUR_TIMES_DAILY = 4

              # Schedule report to run on a daily basis.
              DAILY = 5

              # Schedule report to run on a weekly basis.
              WEEKLY = 6

              # Schedule report to run on a monthly basis.
              MONTHLY = 7
            end
          end

          # Condition for when to email the scheduled report.
          module DeliveryCondition
            # Never deliver report.
            NEVER = 0

            # Always deliver report.
            ALWAYS = 1

            # Deliver report when flag's conditions are met.
            WHEN_FLAG_CONDITIONS_MET = 2
          end
        end
      end
    end
  end
end
