# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Represents a programmatic buyer.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the `ProgrammaticBuyer`.
        #     Format:
        #     `networks/{network_code}/programmaticBuyers/{buyer_account_id}`
        # @!attribute [r] buyer_account_id
        #   @return [::Integer]
        #     Output only. The buyer account ID of the buyer.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The display name of the buyer.
        # @!attribute [r] parent_account_id
        #   @return [::Integer]
        #     Output only. The ID of the programmatic buyer's sponsor. If the buyer has
        #     no sponsor, this field will be -1.
        # @!attribute [r] partner_client_id
        #   @return [::String]
        #     Output only. ID of the Display & Video 360 client buyer partner ID (if
        #     Display & Video 360) or Authorized Buyers client buyer account ID.
        # @!attribute [r] agency
        #   @return [::Boolean]
        #     Output only. Whether the buyer is an advertising agency.
        # @!attribute [r] preferred_deals_enabled
        #   @return [::Boolean]
        #     Output only. Whether the buyer is enabled for preferred deals.
        # @!attribute [r] programmatic_guaranteed_enabled
        #   @return [::Boolean]
        #     Output only. Whether the buyer is enabled for programmatic guaranteed
        #     deals.
        class ProgrammaticBuyer
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
