# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Request object for `GetPlacement` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Placement.
        #     Format: `networks/{network_code}/placements/{placement_id}`
        class GetPlacementRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `ListPlacements` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of Placements.
        #     Format: `networks/{network_code}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of `Placements` to return. The service may
        #     return fewer than this value. If unspecified, at most 50 `Placements` will
        #     be returned. The maximum value is 1000; values greater than 1000 will be
        #     coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListPlacements` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListPlacements` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Expression to filter the response.
        #     See syntax details at
        #     https://developers.google.com/ad-manager/api/beta/filters
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Expression to specify sorting order.
        #     See syntax details at
        #     https://developers.google.com/ad-manager/api/beta/filters#order
        # @!attribute [rw] skip
        #   @return [::Integer]
        #     Optional. Number of individual resources to skip while paginating.
        class ListPlacementsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `ListPlacementsRequest` containing matching `Placement`
        # objects.
        # @!attribute [rw] placements
        #   @return [::Array<::Google::Ads::AdManager::V1::Placement>]
        #     The `Placement` objects from the specified network.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     Total number of `Placement` objects.
        #     If a filter was included in the request, this reflects the total number
        #     after the filtering is applied.
        #
        #     `total_size` won't be calculated in the response unless it has been
        #     included in a response field mask. The response field mask can be provided
        #     to the method by using the URL parameter `$fields` or `fields`, or by using
        #     the HTTP/gRPC header `X-Goog-FieldMask`.
        #
        #     For more information, see
        #     https://developers.google.com/ad-manager/api/beta/field-masks
        class ListPlacementsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `CreatePlacement` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this `Placement` will be created.
        #     Format: `networks/{network_code}`
        # @!attribute [rw] placement
        #   @return [::Google::Ads::AdManager::V1::Placement]
        #     Required. The `Placement` to create.
        class CreatePlacementRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `BatchCreatePlacements` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where the `Placement`s will be created.
        #     Format: `networks/{network_code}`
        #     The parent field in the CreatePlacementRequest messages match this
        #     field.
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Ads::AdManager::V1::CreatePlacementRequest>]
        #     Required. The `Placement` objects to create.
        #     A maximum of 100 objects can be created in a batch.
        class BatchCreatePlacementsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchCreatePlacements` method.
        # @!attribute [rw] placements
        #   @return [::Array<::Google::Ads::AdManager::V1::Placement>]
        #     The `Placement` objects created.
        class BatchCreatePlacementsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `UpdatePlacement` method.
        # @!attribute [rw] placement
        #   @return [::Google::Ads::AdManager::V1::Placement]
        #     Required. The `Placement` to update.
        #
        #     The `Placement`'s name is used to identify the `Placement` to
        #     update. Format:
        #     `networks/{network_code}/placements/{placement_id}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdatePlacementRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `BatchUpdatePlacements` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where `Placements` will be updated.
        #     Format: `networks/{network_code}`
        #     The parent field in the UpdatePlacementsRequest must match this
        #     field.
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Ads::AdManager::V1::UpdatePlacementRequest>]
        #     Required. The `Placement` objects to update.
        #     A maximum of 100 objects can be updated in a batch.
        class BatchUpdatePlacementsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchUpdatePlacements` method.
        # @!attribute [rw] placements
        #   @return [::Array<::Google::Ads::AdManager::V1::Placement>]
        #     The `Placement` objects updated.
        class BatchUpdatePlacementsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `BatchActivatePlacements` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Format: `networks/{network_code}`
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. The names of the `Placement` objects to activate.
        #     Format: `networks/{network_code}/placements/{placement_id}`
        class BatchActivatePlacementsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchActivatePlacements` method.
        class BatchActivatePlacementsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `BatchDeactivatePlacements` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Format: `networks/{network_code}`
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. The names of the `Placement` objects to deactivate.
        #     Format: `networks/{network_code}/placements/{placement_id}`
        class BatchDeactivatePlacementsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchDeactivatePlacements` method.
        class BatchDeactivatePlacementsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `BatchArchivePlacements` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Format: `networks/{network_code}`
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. The names of the `Placement` objects to archive.
        #     Format: `networks/{network_code}/placements/{placement_id}`
        class BatchArchivePlacementsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchArchivePlacements` method.
        class BatchArchivePlacementsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
