# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Wrapper message for
        # {::Google::Ads::AdManager::V1::OrderStatusEnum::OrderStatus OrderStatus}.
        class OrderStatusEnum
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The status of an Order.
          module OrderStatus
            # Default value. This value is unused.
            ORDER_STATUS_UNSPECIFIED = 0

            # Indicates that the Order has just been created but no approval has been
            # requested yet.
            DRAFT = 2

            # Indicates that a request for approval for the Order has been made.
            PENDING_APPROVAL = 3

            # Indicates that the Order has been approved and is ready to serve.
            APPROVED = 4

            # Indicates that the Order has been disapproved and is not eligible to
            # serve.
            DISAPPROVED = 5

            # This is a legacy state. Paused status should be checked on LineItems
            # within the order.
            PAUSED = 6

            # Indicates that the Order has been canceled and cannot serve.
            CANCELED = 7

            # Indicates that the Order has been deleted.
            DELETED = 8
          end
        end
      end
    end
  end
end
