# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # A LineItem contains information about how specific ad creatives are intended
        # to serve to your website or app along with pricing and other delivery
        # details.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the `LineItem`.
        #     Format: `networks/{network_code}/lineItems/{line_item_id}`
        # @!attribute [r] order
        #   @return [::String]
        #     Output only. The ID of the Order to which the LineItem belongs. This
        #     attribute is required. Format: `networks/{network_code}/orders/{order}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The name of the line item. This attribute is required and has a
        #     maximum length of 255 characters.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Required. The date and time on which the LineItem is enabled to begin
        #     serving. This attribute is required and must be in the future.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the LineItem will stop serving. This
        #     attribute is read-only and includes auto extension days.
        # @!attribute [rw] line_item_type
        #   @return [::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType]
        #     Required. Indicates the line item type of a LineItem. This attribute is
        #     required. The line item type determines the default priority of the line
        #     item. More information can be found at
        #     https://support.google.com/admanager/answer/177279.
        # @!attribute [rw] rate
        #   @return [::Google::Type::Money]
        #     Required. The amount of money to spend per impression or click.
        # @!attribute [r] budget
        #   @return [::Google::Type::Money]
        #     Output only. The amount of money allocated to the LineItem. This attribute
        #     is readonly and is populated by Google. The currency code is readonly.
        # @!attribute [rw] custom_field_values
        #   @return [::Array<::Google::Ads::AdManager::V1::CustomFieldValue>]
        #     Optional. The values of the custom fields associated with this line item.
        # @!attribute [rw] goal
        #   @return [::Google::Ads::AdManager::V1::Goal]
        #     Optional. The primary goal that this LineItem is associated with, which is
        #     used in its pacing and budgeting.
        class LineItem
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
