# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Wrapper message for
        # {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType LineItemType}.
        class LineItemTypeEnum
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Indicates the priority of a LineItem, determined by the way in which
          # impressions are reserved to be served for it.
          module LineItemType
            # Not specified value.
            LINE_ITEM_TYPE_UNSPECIFIED = 0

            # The type of LineItem for which a percentage of all the impressions that
            # are being sold are reserved.
            SPONSORSHIP = 12

            # The type of LineItem for which a fixed quantity of impressions or
            # clicks are reserved.
            STANDARD = 13

            # The type of LineItem most commonly used to fill a site's unsold
            # inventory if not contractually obligated to deliver a requested number
            # of impressions. Uses daily percentage of unsold impressions or clicks.
            NETWORK = 9

            # The type of LineItem for which a fixed quantity of impressions or
            # clicks will be delivered at a priority lower than the STANDARD type.
            BULK = 4

            # The type of LineItem most commonly used to fill a site's unsold
            # inventory if not contractually obligated to deliver a requested number
            # of impressions. Uses fixed quantity percentage of unsold impressions or
            # clicks.
            PRICE_PRIORITY = 11

            # The type of LineItem typically used for ads that promote products and
            # services chosen by the publisher.
            HOUSE = 7

            # The type of LineItem used for ads that track ads being served
            # externally of Ad Manager.
            CLICK_TRACKING = 6

            # Targets the LineItem to specific inventory available to AdSense buyers.
            ADSENSE = 2

            # Targets the LineItem to specific inventory available to Authorized Buyers
            # and the Open Auction.
            AD_EXCHANGE = 3

            # Represents a non-monetizable video LineItem that targets one or more
            # bumper positions, which are short house video messages used by
            # publishers to separate content from ad breaks.
            BUMPER = 5

            # The type of LineItem for which there are no impressions reserved, and
            # will serve for a second price bid.
            PREFERRED_DEAL = 10

            # The type of LineItem used for configuring audience extension campaigns.
            AUDIENCE_EXTENSION = 14
          end
        end
      end
    end
  end
end
