# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Wrapper message for
        # {::Google::Ads::AdManager::V1::GoalTypeEnum::GoalType GoalType}.
        class GoalTypeEnum
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the type of the goal for a LineItem.
          module GoalType
            # Default value. This value is unused.
            GOAL_TYPE_UNSPECIFIED = 0

            # No goal is specified for the number of ads delivered.
            # The line item {::Google::Ads::AdManager::V1::LineItem#line_item_type type}
            # must be one of:
            #
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::PRICE_PRIORITY LineItemTypeEnum.LineItemType.PRICE_PRIORITY}
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::AD_EXCHANGE LineItemTypeEnum.LineItemType.AD_EXCHANGE}
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::CLICK_TRACKING LineItemTypeEnum.LineItemType.CLICK_TRACKING}
            NONE = 1

            # There is a goal on the number of ads delivered for this line item during
            # its entire lifetime.
            # The line item {::Google::Ads::AdManager::V1::LineItem#line_item_type type}
            # must be one of:
            #
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::STANDARD LineItemTypeEnum.LineItemType.STANDARD}
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::BULK LineItemTypeEnum.LineItemType.BULK}
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::PRICE_PRIORITY LineItemTypeEnum.LineItemType.PRICE_PRIORITY}
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::ADSENSE LineItemTypeEnum.LineItemType.ADSENSE}
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::AD_EXCHANGE LineItemTypeEnum.LineItemType.AD_EXCHANGE}
            # * [LineItemTypeEnum.LineItemType.ADMOB][]
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::CLICK_TRACKING LineItemTypeEnum.LineItemType.CLICK_TRACKING}
            LIFETIME = 2

            # There is a daily goal on the number of ads delivered for this line item.
            # The line item {::Google::Ads::AdManager::V1::LineItem#line_item_type type}
            # must be one of:
            #
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::SPONSORSHIP LineItemTypeEnum.LineItemType.SPONSORSHIP}
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::NETWORK LineItemTypeEnum.LineItemType.NETWORK}
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::PRICE_PRIORITY LineItemTypeEnum.LineItemType.PRICE_PRIORITY}
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::HOUSE LineItemTypeEnum.LineItemType.HOUSE}
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::ADSENSE LineItemTypeEnum.LineItemType.ADSENSE}
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::AD_EXCHANGE LineItemTypeEnum.LineItemType.AD_EXCHANGE}
            # * [LineItemTypeEnum.LineItemType.ADMOB][]
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::BUMPER LineItemTypeEnum.LineItemType.BUMPER}
            DAILY = 3
          end
        end

        # Wrapper message for
        # {::Google::Ads::AdManager::V1::UnitTypeEnum::UnitType UnitType}.
        class UnitTypeEnum
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Indicates the type of unit used for defining a reservation. The
          # [LineItem.cost_type][] can differ from the UnitType - an
          # ad can have an impression goal, but be billed by its click. Usually
          # CostType and UnitType will refer to the same unit.
          module UnitType
            # Default value. This value is unused.
            UNIT_TYPE_UNSPECIFIED = 0

            # The number of impressions served by creatives associated with the line
            # item.
            IMPRESSIONS = 1

            # The number of clicks reported by creatives associated with the line item.
            # The line item {::Google::Ads::AdManager::V1::LineItem#line_item_type type}
            # must be one of:
            #
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::STANDARD LineItemTypeEnum.LineItemType.STANDARD}
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::BULK LineItemTypeEnum.LineItemType.BULK}
            # * {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::PRICE_PRIORITY LineItemTypeEnum.LineItemType.PRICE_PRIORITY}
            CLICKS = 2

            # The number of click-through Cost-Per-Action (CPA) conversions from
            # creatives associated with the line item. This is only supported as
            # secondary goal and the [LineItem.cost_type][] must be
            # [CostTypeEnum.CostType.CPA][].
            CLICK_THROUGH_CPA_CONVERSIONS = 3

            # The number of view-through Cost-Per-Action (CPA) conversions from
            # creatives associated with the line item. This is only supported as
            # secondary goal and the [LineItem.cost_type][] must be
            # [CostTypeEnum.CostType.CPA}.
            VIEW_THROUGH_CPA_CONVERSIONS = 4

            # The number of total Cost-Per-Action (CPA) conversions from creatives
            # associated with the line item. This is only supported as secondary goal
            # and the [LineItem.cost_type} must be [CostTypeEnum.CostType.CPA}.
            TOTAL_CPA_CONVERSIONS = 5

            # The number of viewable impressions reported by creatives associated with
            # the line item. The
            # {::Google::Ads::AdManager::V1::LineItem#line_item_type LineItem.line_item_type}
            # must be
            # {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::STANDARD LineItemTypeEnum.LineItemType.STANDARD}.
            VIEWABLE_IMPRESSIONS = 6

            # The number of in-target impressions reported by third party measurements.
            # The
            # {::Google::Ads::AdManager::V1::LineItem#line_item_type LineItem.line_item_type}
            # must be
            # {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::STANDARD LineItemTypeEnum.LineItemType.STANDARD}.
            IN_TARGET_IMPRESSIONS = 7
          end
        end
      end
    end
  end
end
