# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Defines the criteria a {::Google::Ads::AdManager::V1::LineItem LineItem} needs to
        # satisfy to meet its delivery goal.
        # @!attribute [rw] goal_type
        #   @return [::Google::Ads::AdManager::V1::GoalTypeEnum::GoalType]
        #     The type of the goal for the LineItem. It defines the period over which the
        #     goal should be reached.
        # @!attribute [rw] unit_type
        #   @return [::Google::Ads::AdManager::V1::UnitTypeEnum::UnitType]
        #     The type of the goal unit for the LineItem.
        # @!attribute [rw] units
        #   @return [::Integer]
        #     If this is a primary goal, it represents the number or percentage of
        #     impressions or clicks that will be reserved. If the line item is of type
        #     {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::SPONSORSHIP LineItemTypeEnum.LineItemType.SPONSORSHIP},
        #     it represents the percentage of available impressions reserved. If the line
        #     item is of type
        #     {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::BULK LineItemTypeEnum.LineItemType.BULK}
        #     or
        #     {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::PRICE_PRIORITY LineItemTypeEnum.LineItemType.PRICE_PRIORITY},
        #     it represents the number of remaining impressions reserved. If the line
        #     item is of type
        #     {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::NETWORK LineItemTypeEnum.LineItemType.NETWORK}
        #     or
        #     {::Google::Ads::AdManager::V1::LineItemTypeEnum::LineItemType::HOUSE LineItemTypeEnum.LineItemType.HOUSE},
        #     it represents the percentage of remaining impressions reserved. <p>If this
        #     is an impression cap goal, it represents the number of impressions or
        #     conversions that the line item will stop serving at if reached. For valid
        #     line item types, see [LineItem.impressions_cap][].
        class Goal
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
