# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Represents a location in the world, for targeting.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the `GeoTarget`.
        #     Format: `networks/{network_code}/geoTargets/{geo_target_id}`
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The display name of the GeoTarget.
        # @!attribute [r] canonical_parent
        #   @return [::String]
        #     Output only. The name of the direct parent that defines the canonical name
        #     of the geo target. For example, if the current geo target is "San
        #     Francisco", its canonical name would be "San Francisco, California, United
        #     States" thus the canonical_parent would be the name of California and the
        #     canonical_parent of California would be the name of United states Format:
        #     `networks/{network_code}/geoTargets/{geo_target}`
        # @!attribute [r] parent_names
        #   @return [::Array<::String>]
        #     Output only. All parents of the geo target ordered by ascending size.
        # @!attribute [r] region_code
        #   @return [::String]
        #     Output only. The Unicode CLDR region code of the geo target.
        # @!attribute [r] type
        #   @return [::String]
        #     Output only. The location type (unlocalized) for this geographical entity.
        # @!attribute [r] targetable
        #   @return [::Boolean]
        #     Output only. Whether the geo target is targetable.
        class GeoTarget
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
