# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Request object for `GetEntitySignalsMapping` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the EntitySignalsMapping.
        #     Format:
        #     `networks/{network_code}/entitySignalsMappings/{entity_signals_mapping_id}`
        class GetEntitySignalsMappingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `ListEntitySignalsMappings` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of EntitySignalsMappings.
        #     Format: `networks/{network_code}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of `EntitySignalsMappings` to return. The
        #     service may return fewer than this value. If unspecified, at most 50
        #     `EntitySignalsMappings` will be returned. The maximum value is 1000; values
        #     above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     `ListEntitySignalsMappings` call. Provide this to retrieve the subsequent
        #     page.
        #
        #     When paginating, all other parameters provided to
        #     `ListEntitySignalsMappings` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Expression to filter the response.
        #     See syntax details at
        #     https://developers.google.com/ad-manager/api/beta/filters
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Expression to specify sorting order.
        #     See syntax details at
        #     https://developers.google.com/ad-manager/api/beta/filters#order
        # @!attribute [rw] skip
        #   @return [::Integer]
        #     Optional. Number of individual resources to skip while paginating.
        class ListEntitySignalsMappingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for 'CreateEntitySignalsMapping' method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this EntitySignalsMapping will be
        #     created. Format: `networks/{network_code}`
        # @!attribute [rw] entity_signals_mapping
        #   @return [::Google::Ads::AdManager::V1::EntitySignalsMapping]
        #     Required. The EntitySignalsMapping object to create.
        class CreateEntitySignalsMappingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for 'UpdateEntitySignalsMapping' method.
        # @!attribute [rw] entity_signals_mapping
        #   @return [::Google::Ads::AdManager::V1::EntitySignalsMapping]
        #     Required. The `EntitySignalsMapping` to update.
        #
        #     The EntitySignalsMapping's name is used to identify the
        #     EntitySignalsMapping to update.
        #     Format:
        #     `networks/{network_code}/entitySignalsMappings/{entity_signals_mapping}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateEntitySignalsMappingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `ListEntitySignalsMappingsRequest` containing matching
        # `EntitySignalsMapping` resources.
        # @!attribute [rw] entity_signals_mappings
        #   @return [::Array<::Google::Ads::AdManager::V1::EntitySignalsMapping>]
        #     The `EntitySignalsMapping` from the specified network.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     Total number of `EntitySignalsMappings`.
        #     If a filter was included in the request, this reflects the total number
        #     after the filtering is applied.
        #
        #     `total_size` won't be calculated in the response unless it has been
        #     included in a response field mask. The response field mask can be provided
        #     to the method by using the URL parameter `$fields` or `fields`, or by using
        #     the HTTP/gRPC header `X-Goog-FieldMask`.
        #
        #     For more information, see
        #     https://developers.google.com/ad-manager/api/beta/field-masks
        class ListEntitySignalsMappingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `BatchCreateEntitySignalsMappings` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where `EntitySignalsMappings` will be
        #     created. Format: `networks/{network_code}` The parent field in the
        #     CreateEntitySignalsMappingRequest must match this field.
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Ads::AdManager::V1::CreateEntitySignalsMappingRequest>]
        #     Required. The `EntitySignalsMapping` objects to create.
        #     A maximum of 100 objects can be created in a batch.
        class BatchCreateEntitySignalsMappingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchCreateEntitySignalsMappings` method.
        # @!attribute [rw] entity_signals_mappings
        #   @return [::Array<::Google::Ads::AdManager::V1::EntitySignalsMapping>]
        #     The `EntitySignalsMapping` objects created.
        class BatchCreateEntitySignalsMappingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `BatchUpdateEntitySignalsMappings` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where `EntitySignalsMappings` will be
        #     updated. Format: `networks/{network_code}` The parent field in the
        #     UpdateEntitySignalsMappingRequest must match this field.
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Ads::AdManager::V1::UpdateEntitySignalsMappingRequest>]
        #     Required. The `EntitySignalsMapping` objects to update.
        #     A maximum of 100 objects can be updated in a batch.
        class BatchUpdateEntitySignalsMappingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchUpdateEntitySignalsMappings` method.
        # @!attribute [rw] entity_signals_mappings
        #   @return [::Array<::Google::Ads::AdManager::V1::EntitySignalsMapping>]
        #     The `EntitySignalsMapping` objects updated.
        class BatchUpdateEntitySignalsMappingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
