# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Request object for `GetCustomTargetingKey` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the CustomTargetingKey.
        #     Format:
        #     `networks/{network_code}/customTargetingKeys/{custom_targeting_key_id}`
        class GetCustomTargetingKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `ListCustomTargetingKeys` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of CustomTargetingKeys.
        #     Format: `networks/{network_code}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of `CustomTargetingKeys` to return. The
        #     service may return fewer than this value. If unspecified, at most 50
        #     `CustomTargetingKeys` will be returned. The maximum value is 1000; values
        #     above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListCustomTargetingKeys`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListCustomTargetingKeys`
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Expression to filter the response.
        #     See syntax details at
        #     https://developers.google.com/ad-manager/api/beta/filters
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Expression to specify sorting order.
        #     See syntax details at
        #     https://developers.google.com/ad-manager/api/beta/filters#order
        # @!attribute [rw] skip
        #   @return [::Integer]
        #     Optional. Number of individual resources to skip while paginating.
        class ListCustomTargetingKeysRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `ListCustomTargetingKeysRequest` containing matching
        # `CustomTargetingKey` objects.
        # @!attribute [rw] custom_targeting_keys
        #   @return [::Array<::Google::Ads::AdManager::V1::CustomTargetingKey>]
        #     The `CustomTargetingKey` objects from the specified network.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     Total number of `CustomTargetingKey` objects.
        #     If a filter was included in the request, this reflects the total number
        #     after the filtering is applied.
        #
        #     `total_size` won't be calculated in the response unless it has been
        #     included in a response field mask. The response field mask can be provided
        #     to the method by using the URL parameter `$fields` or `fields`, or by using
        #     the HTTP/gRPC header `X-Goog-FieldMask`.
        #
        #     For more information, see
        #     https://developers.google.com/ad-manager/api/beta/field-masks
        class ListCustomTargetingKeysResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `CreateCustomTargetingKey` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this `CustomTargetingKey` will be
        #     created. Format: `networks/{network_code}`
        # @!attribute [rw] custom_targeting_key
        #   @return [::Google::Ads::AdManager::V1::CustomTargetingKey]
        #     Required. The `CustomTargetingKey` to create.
        class CreateCustomTargetingKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `BatchCreateCustomTargetingKeys` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where `CustomTargetingKeys` will be created.
        #     Format: `networks/{network_code}`
        #     The parent field in the CreateCustomTargetingKeyRequest must match this
        #     field.
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Ads::AdManager::V1::CreateCustomTargetingKeyRequest>]
        #     Required. The `CustomTargetingKey` objects to create.
        #     A maximum of 100 objects can be created in a batch.
        class BatchCreateCustomTargetingKeysRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchCreateCustomTargetingKeys` method.
        # @!attribute [rw] custom_targeting_keys
        #   @return [::Array<::Google::Ads::AdManager::V1::CustomTargetingKey>]
        #     The `CustomTargetingKey` objects created.
        class BatchCreateCustomTargetingKeysResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `UpdateCustomTargetingKey` method.
        # @!attribute [rw] custom_targeting_key
        #   @return [::Google::Ads::AdManager::V1::CustomTargetingKey]
        #     Required. The `CustomTargetingKey` to update.
        #
        #     The `CustomTargetingKey`'s `name` is used to identify the
        #     `CustomTargetingKey` to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateCustomTargetingKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `BatchUpdateCustomTargetingKeys` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where `CustomTargetingKeys` will be updated.
        #     Format: `networks/{network_code}`
        #     The parent field in the UpdateCustomTargetingKeyRequest must match this
        #     field.
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Ads::AdManager::V1::UpdateCustomTargetingKeyRequest>]
        #     Required. The `CustomTargetingKey` objects to update.
        #     A maximum of 100 objects can be updated in a batch.
        class BatchUpdateCustomTargetingKeysRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchUpdateCustomTargetingKeys` method.
        # @!attribute [rw] custom_targeting_keys
        #   @return [::Array<::Google::Ads::AdManager::V1::CustomTargetingKey>]
        #     The `CustomTargetingKey` objects updated.
        class BatchUpdateCustomTargetingKeysResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `BatchActivateCustomTargetingKeys` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Format: `networks/{network_code}`
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. The resource names of the `CustomTargetingKey`s to activate.
        #     Format:
        #     `networks/{network_code}/customTargetingKeys/{custom_targeting_key_id}`
        class BatchActivateCustomTargetingKeysRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchActivateCustomTargetingKeys` method.
        class BatchActivateCustomTargetingKeysResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `BatchDeactivateCustomTargetingKeys` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Format: `networks/{network_code}`
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. The resource names of the `CustomTargetingKey`s to deactivate.
        #     Format:
        #     `networks/{network_code}/customTargetingKeys/{custom_targeting_key_id}`
        class BatchDeactivateCustomTargetingKeysRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchDeactivateCustomTargetingKeys` method.
        class BatchDeactivateCustomTargetingKeysResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
