# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # An additional, user-created field on an entity.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the `CustomField`.
        #     Format: `networks/{network_code}/customFields/{custom_field}`
        # @!attribute [r] custom_field_id
        #   @return [::Integer]
        #     Output only. Unique ID of the CustomField. This attribute is assigned by
        #     Google.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Name of the CustomField. The max length is 127 characters.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A description of the custom field. The maximum length is 511
        #     characters.
        # @!attribute [r] status
        #   @return [::Google::Ads::AdManager::V1::CustomFieldStatusEnum::CustomFieldStatus]
        #     Output only. The status of the `CustomField`.
        # @!attribute [rw] entity_type
        #   @return [::Google::Ads::AdManager::V1::CustomFieldEntityTypeEnum::CustomFieldEntityType]
        #     Required. The type of entity the `CustomField` can be applied to.
        # @!attribute [rw] data_type
        #   @return [::Google::Ads::AdManager::V1::CustomFieldDataTypeEnum::CustomFieldDataType]
        #     Required. The data type of the `CustomField`.
        # @!attribute [rw] visibility
        #   @return [::Google::Ads::AdManager::V1::CustomFieldVisibilityEnum::CustomFieldVisibility]
        #     Required. The visibility of the `CustomField`.
        # @!attribute [rw] options
        #   @return [::Array<::Google::Ads::AdManager::V1::CustomFieldOption>]
        #     Optional. The drop-down options for the `CustomField`.
        #
        #     Only applicable for `CustomField` with the drop-down data type.
        class CustomField
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An option for a drop-down `CustomField`.
        # @!attribute [rw] custom_field_option_id
        #   @return [::Integer]
        #     Optional. Non-empty default. `CustomFieldOption` ID.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the `CustomFieldOption`.
        #
        #     This value has a maximum length of 127 characters.
        class CustomFieldOption
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
