# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # A template that can be used to create a [TemplateCreative][].
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the creative template.
        #     Format: `networks/{network_code}/creativeTemplates/{creative_template_id}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the creative template. This has a maximum
        #     length of 255 characters.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the creative template.
        # @!attribute [rw] snippet
        #   @return [::String]
        #     Required. The code snippet of the creative template, with placeholders for
        #     the associated variables.
        # @!attribute [r] status
        #   @return [::Google::Ads::AdManager::V1::CreativeTemplateStatusEnum::CreativeTemplateStatus]
        #     Output only. The status of the creative template. This attribute is
        #     assigned by Google.
        # @!attribute [rw] type
        #   @return [::Google::Ads::AdManager::V1::CreativeTemplateTypeEnum::CreativeTemplateType]
        #     Optional. The type of the creative template. Users can only create or
        #     update `CreativeTemplateType.CUSTOM` templates.
        # @!attribute [rw] interstitial
        #   @return [::Boolean]
        #     Optional. `True` if this creative template produces out-of-page creatives.
        #     Creative templates with this setting enabled must include the viewed
        #     impression macro.
        # @!attribute [rw] native_eligible
        #   @return [::Boolean]
        #     Optional. `True` if this creative template produces native-eligible
        #     creatives.
        # @!attribute [rw] native_video_eligible
        #   @return [::Boolean]
        #     Optional. `True` if this creative template produces native video-eligible
        #     creatives.
        # @!attribute [rw] safe_frame_compatible
        #   @return [::Boolean]
        #     Optional. Whether the Creative produced is compatible for SafeFrame
        #     rendering. This attribute defaults to `True`.
        # @!attribute [rw] variables
        #   @return [::Array<::Google::Ads::AdManager::V1::CreativeTemplateVariable>]
        #     Required. The list of creative template variables.
        class CreativeTemplate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a variable defined in a creative template.
        # @!attribute [rw] asset_variable
        #   @return [::Google::Ads::AdManager::V1::CreativeTemplateVariable::AssetCreativeTemplateVariable]
        #     Optional. Represents a file asset variable defined in a creative
        #     template.
        #
        #     Note: The following fields are mutually exclusive: `asset_variable`, `list_string_variable`, `long_variable`, `string_variable`, `url_variable`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] list_string_variable
        #   @return [::Google::Ads::AdManager::V1::CreativeTemplateVariable::ListStringCreativeTemplateVariable]
        #     Optional. Represents a list variable defined in a creative template.
        #
        #     Note: The following fields are mutually exclusive: `list_string_variable`, `asset_variable`, `long_variable`, `string_variable`, `url_variable`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] long_variable
        #   @return [::Google::Ads::AdManager::V1::CreativeTemplateVariable::LongCreativeTemplateVariable]
        #     Optional. Represents a long variable defined in a creative template.
        #
        #     Note: The following fields are mutually exclusive: `long_variable`, `asset_variable`, `list_string_variable`, `string_variable`, `url_variable`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] string_variable
        #   @return [::Google::Ads::AdManager::V1::CreativeTemplateVariable::StringCreativeTemplateVariable]
        #     Optional. Represents a string variable defined in a creative template.
        #
        #     Note: The following fields are mutually exclusive: `string_variable`, `asset_variable`, `list_string_variable`, `long_variable`, `url_variable`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] url_variable
        #   @return [::Google::Ads::AdManager::V1::CreativeTemplateVariable::UrlCreativeTemplateVariable]
        #     Optional. Represents a url variable defined in a creative template.
        #
        #     Note: The following fields are mutually exclusive: `url_variable`, `asset_variable`, `list_string_variable`, `long_variable`, `string_variable`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] label
        #   @return [::String]
        #     Required. Label that is displayed to users when creating from the creative
        #     template. This has a maximum length of 127 characters.
        # @!attribute [r] unique_display_name
        #   @return [::String]
        #     Output only. Unique name used to identify the variable. This attribute is
        #     assigned by Google when a creative template variable is created.
        # @!attribute [rw] description
        #   @return [::String]
        #     Required. A descriptive help text that is displayed to users along with the
        #     label. This attribute has a maximum length of 255 characters.
        # @!attribute [rw] required
        #   @return [::Boolean]
        #     Optional. `True` if this variable is required to be filled in by users when
        #     creating a creative from the creative template.
        class CreativeTemplateVariable
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a file asset variable defined in a creative template.
          #
          # Use [AssetCreativeTemplateVariableValue][] to specify the value for this
          # variable when creating a [TemplateCreative][] from a
          # {::Google::Ads::AdManager::V1::CreativeTemplate CreativeTemplate}.
          # @!attribute [rw] mime_types
          #   @return [::Array<::Google::Ads::AdManager::V1::CreativeTemplateVariable::AssetCreativeTemplateVariable::MimeType>]
          #     Optional. The set of allowed MIME types. If unspecified, all MIME types
          #     are allowed.
          class AssetCreativeTemplateVariable
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Different MIME types that the asset variable supports.
            module MimeType
              # Default value. This value is unused.
              MIME_TYPE_UNSPECIFIED = 0

              # The `image/jpeg` MIME type.
              JPG = 1

              # The `image/png` MIME type.
              PNG = 2

              # The `image/gif` MIME type.
              GIF = 3
            end
          end

          # Represents a list variable defined in a creative template. This is similar
          # to
          # {::Google::Ads::AdManager::V1::CreativeTemplateVariable::StringCreativeTemplateVariable StringCreativeTemplateVariable},
          # except that there are possible choices to choose from.
          #
          # Use [StringCreativeTemplateVariableValue][] to specify the value
          # for this variable when creating a [TemplateCreative][] from a
          # {::Google::Ads::AdManager::V1::CreativeTemplate CreativeTemplate}.
          # @!attribute [rw] default_value
          #   @return [::String]
          #     Optional. Default value to be filled in when creating creatives from the
          #     creative template.
          # @!attribute [rw] sample_value
          #   @return [::String]
          #     Optional. Sample value that is used when previewing the template in the
          #     UI.
          # @!attribute [rw] choices
          #   @return [::Array<::Google::Ads::AdManager::V1::CreativeTemplateVariable::ListStringCreativeTemplateVariable::VariableChoice>]
          #     Optional. The selectable values that the user can choose from.
          # @!attribute [rw] allow_other_choice
          #   @return [::Boolean]
          #     Optional. `True` if a user can specify an 'other' value. For example, if
          #     a variable called backgroundColor is defined as a list with values: red,
          #     green, blue, this boolean can be set to allow a user to enter a value not
          #     on the list such as purple.
          class ListStringCreativeTemplateVariable
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Stores variable choices selectable by users.
            # @!attribute [rw] label
            #   @return [::String]
            #     Required. A label is displayed to users when creating a
            #     [TemplateCreative][]. This attribute is intended to be more descriptive
            #     than value. This attribute has a maximum length of 255 characters.
            # @!attribute [rw] value
            #   @return [::String]
            #     Required. When creating a [TemplateCreative][], the value in
            #     [StringCreativeTemplateVariableValue][] should match this value, if you
            #     intend to select this value. This attribute has a maximum length of 255
            #     characters.
            class VariableChoice
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Represents a long variable defined in a creative template.
          #
          # Use [LongCreativeTemplateVariableValue][] to specify the value
          # for this variable when creating [TemplateCreative][] from a
          # {::Google::Ads::AdManager::V1::CreativeTemplate CreativeTemplate}.
          # @!attribute [rw] default_value
          #   @return [::Integer]
          #     Optional. Default value to be filled in when creating creatives from the
          #     creative template.
          # @!attribute [rw] sample_value
          #   @return [::Integer]
          #     Optional. Sample value that is used when previewing the template in the
          #     UI.
          class LongCreativeTemplateVariable
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a string variable defined in a creative template.
          #
          # Use [StringCreativeTemplateVariableValue][] to specify the value
          # for this variable when creating [TemplateCreative][] from a
          # {::Google::Ads::AdManager::V1::CreativeTemplate CreativeTemplate}.
          # @!attribute [rw] default_value
          #   @return [::String]
          #     Optional. Default value to be filled in when creating creatives from the
          #     creative template.
          # @!attribute [rw] sample_value
          #   @return [::String]
          #     Optional. Sample value that is used when previewing the template in the
          #     UI.
          class StringCreativeTemplateVariable
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a url variable defined in a creative template.
          #
          # Use [UrlCreativeTemplateVariableValue][] to specify the value for this
          # variable when creating a [TemplateCreative][] from a
          # {::Google::Ads::AdManager::V1::CreativeTemplate CreativeTemplate}.
          # @!attribute [rw] default_value
          #   @return [::String]
          #     Optional. Default value to be filled in when creating creatives from the
          #     creative template.
          # @!attribute [rw] sample_value
          #   @return [::String]
          #     Optional. Sample value that is used when previewing the template in the
          #     UI.
          # @!attribute [rw] url_type
          #   @return [::Google::Ads::AdManager::V1::CreativeTemplateVariableUrlTypeEnum::CreativeTemplateVariableUrlType]
          #     Optional. The type of URL that this variable represents. Different types
          #     of URLs may be handled differently at rendering time.
          class UrlCreativeTemplateVariable
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
