# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # A contact represents a person who is affiliated with a single company. A
        # contact can have a variety of contact information associated to it, and can
        # be invited to view their company's orders, line items, creatives, and
        # reports.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the `Contact`.
        #     Format: `networks/{network_code}/contacts/{contact_id}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The name of the contact. This attribute has a maximum length of
        #     127 characters.
        # @!attribute [rw] company
        #   @return [::String]
        #     Required. Immutable. The resource name of the Company.
        #     Format: "networks/\\{network_code}/companies/\\{company_id}"
        # @!attribute [r] status
        #   @return [::Google::Ads::AdManager::V1::ContactStatusEnum::ContactStatus]
        #     Output only. The status of the contact. This attribute is assigned by
        #     Google.
        # @!attribute [rw] address
        #   @return [::String]
        #     Optional. The address of the contact. This attribute has a maximum length
        #     of 1024 characters.
        # @!attribute [rw] cell_phone
        #   @return [::String]
        #     Optional. The cell phone number where the contact can be reached.
        # @!attribute [rw] comment
        #   @return [::String]
        #     Optional. A free-form text comment for the contact. This attribute has a
        #     maximum length of 1024 characters.
        # @!attribute [rw] email
        #   @return [::String]
        #     Optional. The e-mail address where the contact can be reached. This
        #     attribute has a maximum length of 128 characters.
        # @!attribute [rw] fax
        #   @return [::String]
        #     Optional. The fax number where the contact can be reached. This attribute
        #     has a maximum length of 1024 characters.
        # @!attribute [rw] title
        #   @return [::String]
        #     Optional. The job title of the contact. This attribute has a maximum length
        #     of 1024 characters.
        # @!attribute [rw] work_phone
        #   @return [::String]
        #     Optional. The work phone number where the contact can be reached. This
        #     attribute has a maximum length of 1024 characters.
        class Contact
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
