# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # The `Company` resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the `Company`.
        #     Format: `networks/{network_code}/companies/{company_id}`
        # @!attribute [r] company_id
        #   @return [::Integer]
        #     Output only. `Company` ID.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the `Company`.
        #
        #     This value has a maximum length of 127 characters.
        # @!attribute [rw] type
        #   @return [::Google::Ads::AdManager::V1::CompanyTypeEnum::CompanyType]
        #     Required. The type of the `Company`.
        # @!attribute [rw] address
        #   @return [::String]
        #     Optional. The address for the `Company`.
        #
        #     This value has a maximum length of 1024 characters.
        # @!attribute [rw] email
        #   @return [::String]
        #     Optional. The email for the `Company`.
        #
        #     This value has a maximum length of 128 characters.
        # @!attribute [rw] fax
        #   @return [::String]
        #     Optional. The fax number for the `Company`.
        #
        #     This value has a maximum length of 63 characters.
        # @!attribute [rw] phone
        #   @return [::String]
        #     Optional. The phone number for the `Company`.
        #
        #     This value has a maximum length of 63 characters.
        # @!attribute [rw] external_id
        #   @return [::String]
        #     Optional. The external ID for the `Company`.
        #
        #     This value has a maximum length of 255 characters.
        # @!attribute [rw] comment
        #   @return [::String]
        #     Optional. Comments about the `Company`.
        #
        #     This value has a maximum length of 1024 characters.
        # @!attribute [rw] credit_status
        #   @return [::Google::Ads::AdManager::V1::CompanyCreditStatusEnum::CompanyCreditStatus]
        #     Optional. The credit status of the `Company`.
        #
        #     This attribute defaults to `ACTIVE` if basic settings are enabled and
        #     `ON_HOLD` if advance settings are enabled.
        # @!attribute [rw] applied_labels
        #   @return [::Array<::Google::Ads::AdManager::V1::AppliedLabel>]
        #     Optional. The labels that are directly applied to the `Company`.
        # @!attribute [rw] primary_contact
        #   @return [::String]
        #     Optional. The resource names of primary Contact of the `Company`.
        #     Format: "networks/\\{network_code}/contacts/\\{contact_id}"
        # @!attribute [rw] applied_teams
        #   @return [::Array<::String>]
        #     Optional. The resource names of Teams that are directly associated with the
        #     `Company`. Format: "networks/\\{network_code}/teams/\\{team_id}"
        # @!attribute [rw] third_party_company_id
        #   @return [::Integer]
        #     Optional. The ID of the Google-recognized canonicalized form of the
        #     `Company`.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the `Company` was last modified.
        class Company
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
