# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Wrapper message for
        # {::Google::Ads::AdManager::V1::CompanyTypeEnum::CompanyType CompanyType}
        class CompanyTypeEnum
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of a company.
          module CompanyType
            # No value specified
            COMPANY_TYPE_UNSPECIFIED = 0

            # A business entity that purchases ad inventory.
            ADVERTISER = 1

            # A company representing the publisher's own advertiser for house ads.
            HOUSE_ADVERTISER = 2

            # An organization that manages ad accounts and offers services, such as ad
            # creation, placement, and management to advertisers.
            AGENCY = 3

            # A company representing the publisher's own agency.
            HOUSE_AGENCY = 4

            # A company representing multiple advertisers and agencies.
            AD_NETWORK = 5
          end
        end

        # Wrapper message for
        # {::Google::Ads::AdManager::V1::CompanyCreditStatusEnum::CompanyCreditStatus CompanyCreditStatus}
        class CompanyCreditStatusEnum
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The credit status of a company.
          #
          # Credit statuses specify the credit-worthiness of a company and affect the
          # ad serving of campaigns belonging to the company.
          #
          # In basic settings, only the
          # {::Google::Ads::AdManager::V1::CompanyCreditStatusEnum::CompanyCreditStatus::ACTIVE ACTIVE}
          # and
          # {::Google::Ads::AdManager::V1::CompanyCreditStatusEnum::CompanyCreditStatus::INACTIVE INACTIVE}
          # credit statuses are applicable. In advance settings, all credit statuses
          # are applicable.
          module CompanyCreditStatus
            # No value specified
            COMPANY_CREDIT_STATUS_UNSPECIFIED = 0

            # The company's credit status is active.
            #
            # Line items belonging to the company can serve.
            #
            # This credit status is the default for basic settings and is available in
            # both basic and advance settings.
            ACTIVE = 1

            # The company's credit status is inactive.
            #
            # Line items belonging to the company cannot be activated. However, line
            # items that were activated before the credit status changed will remain
            # active. New orders or line items belonging to the company cannot be
            # created.
            #
            # Companies with this credit status will be hidden by default in company
            # search results.
            #
            # This credit status is available in both basic and advance settings.
            INACTIVE = 2

            # The company's credit status is on hold.
            #
            # Line items belonging to the company cannot be activated. However, line
            # items that were activated before the credit status changed will remain
            # active. New orders or line items belonging to the company can be
            # created.
            #
            # This credit status is the default in advance settings and is only
            # available in advance settings.
            ON_HOLD = 3

            # The company's credit status is stopped.
            #
            # Line items belonging to the company cannot be activated. However, line
            # items that were activated before the credit status changed will remain
            # active. New orders or line items belonging to the company cannot be
            # created.
            #
            # This credit status is only available in advance settings.
            STOP = 4

            # The company's credit status is blocked.
            #
            # All active line items belonging to the company will stop serving with
            # immediate effect. Line items belonging to the company cannot be
            # activated, and new orders or line items belonging to the company cannot
            # be created.
            #
            # This credit status is only available in advance settings.
            BLOCKED = 5
          end
        end
      end
    end
  end
end
