# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # The AdUnit resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the AdUnit.
        #     Format: `networks/{network_code}/adUnits/{ad_unit_id}`
        # @!attribute [r] ad_unit_id
        #   @return [::Integer]
        #     Output only. AdUnit ID.
        # @!attribute [rw] parent_ad_unit
        #   @return [::String]
        #     Required. Immutable. The AdUnit's parent. Every ad unit has a parent except
        #     for the root ad unit, which is created by Google. Format:
        #     "networks/\\{network_code}/adUnits/\\{ad_unit_id}"
        # @!attribute [r] parent_path
        #   @return [::Array<::Google::Ads::AdManager::V1::AdUnitParent>]
        #     Output only. The path to this AdUnit in the ad unit hierarchy represented
        #     as a list from the root to this ad unit's parent. For root ad units, this
        #     list is empty.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the ad unit. Its maximum length is 255
        #     characters.
        # @!attribute [rw] ad_unit_code
        #   @return [::String]
        #     Optional. Immutable. A string used to uniquely identify the ad unit for the
        #     purposes of serving the ad. This attribute can be set during ad unit
        #     creation. If it is not provided, it will be assigned by Google based on the
        #     ad unit ID.
        # @!attribute [r] status
        #   @return [::Google::Ads::AdManager::V1::AdUnitStatusEnum::AdUnitStatus]
        #     Output only. The status of this ad unit.  It defaults to ACTIVE.
        # @!attribute [rw] applied_target_window
        #   @return [::Google::Ads::AdManager::V1::TargetWindowEnum::TargetWindow]
        #     Optional. The target window directly applied to this AdUnit.
        #     If this field is not set, this AdUnit uses the target window specified in
        #     effectiveTargetWindow.
        # @!attribute [r] effective_target_window
        #   @return [::Google::Ads::AdManager::V1::TargetWindowEnum::TargetWindow]
        #     Output only. Non-empty default. The target window of this AdUnit. This
        #     value is inherited from ancestor AdUnits and defaults to TOP if no AdUnit
        #     in the hierarchy specifies it.
        # @!attribute [rw] applied_teams
        #   @return [::Array<::String>]
        #     Optional. The resource names of Teams directly applied to this AdUnit.
        #     Format: "networks/\\{network_code}/teams/\\{team_id}"
        # @!attribute [r] teams
        #   @return [::Array<::String>]
        #     Output only. The resource names of all Teams that this AdUnit is on as well
        #     as those inherited from parent AdUnits. Format:
        #     "networks/\\{network_code}/teams/\\{team_id}"
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A description of the ad unit. The maximum length is 65,535
        #     characters.
        # @!attribute [rw] explicitly_targeted
        #   @return [::Boolean]
        #     Optional. If this field is set to true, then the AdUnit will not be
        #     implicitly targeted when its parent is. Traffickers must explicitly
        #     target such an AdUnit or else no line items will serve to it. This
        #     feature is only available for Ad Manager 360 accounts.
        # @!attribute [r] has_children
        #   @return [::Boolean]
        #     Output only. This field is set to true if the ad unit has any children.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time this AdUnit was last modified.
        # @!attribute [rw] ad_unit_sizes
        #   @return [::Array<::Google::Ads::AdManager::V1::AdUnitSize>]
        #     Optional. The sizes that can be served inside this ad unit.
        # @!attribute [rw] external_set_top_box_channel_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Optional. Determines what set top box video on demand channel this ad unit
        #     corresponds to in an external set top box ad campaign system.
        # @!attribute [rw] refresh_delay
        #   @return [::Google::Protobuf::Duration]
        #     Optional. The duration after which an Ad Unit will automatically refresh.
        #     This is only valid for ad units in mobile apps. If not set, the ad unit
        #     will not refresh.
        # @!attribute [rw] applied_labels
        #   @return [::Array<::Google::Ads::AdManager::V1::AppliedLabel>]
        #     Optional. The set of labels applied directly to this ad unit.
        # @!attribute [r] effective_applied_labels
        #   @return [::Array<::Google::Ads::AdManager::V1::AppliedLabel>]
        #     Output only. Contains the set of labels applied directly to the ad unit as
        #     well as those inherited from the parent ad units. If a label has been
        #     negated, only the negated label is returned. This attribute is assigned by
        #     Google.
        # @!attribute [rw] applied_label_frequency_caps
        #   @return [::Array<::Google::Ads::AdManager::V1::LabelFrequencyCap>]
        #     Optional. The set of label frequency caps applied directly to this ad unit.
        #     There is a limit of 10 label frequency caps per ad unit.
        # @!attribute [r] effective_label_frequency_caps
        #   @return [::Array<::Google::Ads::AdManager::V1::LabelFrequencyCap>]
        #     Output only. The label frequency caps applied directly to the ad unit as
        #     well as those inherited from parent ad units.
        # @!attribute [rw] smart_size_mode
        #   @return [::Google::Ads::AdManager::V1::SmartSizeModeEnum::SmartSizeMode]
        #     Optional. Non-empty default. The smart size mode for this ad unit. This
        #     attribute defaults to SmartSizeMode.NONE for fixed sizes.
        # @!attribute [rw] applied_adsense_enabled
        #   @return [::Boolean]
        #     Optional. The value of AdSense enabled directly applied to this ad unit. If
        #     not specified this ad unit will inherit the value of
        #     effectiveAdsenseEnabled from its ancestors.
        # @!attribute [r] effective_adsense_enabled
        #   @return [::Boolean]
        #     Output only. Specifies whether or not the AdUnit is enabled for serving ads
        #     from the AdSense content network. This attribute defaults to the ad unit's
        #     parent or ancestor's setting if one has been set. If no ancestor of the ad
        #     unit has set appliedAdsenseEnabled, the attribute is defaulted to true.
        class AdUnit
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the size, environment, and companions of an ad in an ad unit.
        # @!attribute [rw] size
        #   @return [::Google::Ads::AdManager::V1::Size]
        #     Required. The Size of the AdUnit.
        # @!attribute [rw] environment_type
        #   @return [::Google::Ads::AdManager::V1::EnvironmentTypeEnum::EnvironmentType]
        #     Required. The EnvironmentType of the AdUnit
        # @!attribute [rw] companions
        #   @return [::Array<::Google::Ads::AdManager::V1::Size>]
        #     The companions for this ad unit size. Companions are only valid if the
        #     environment is
        #     {::Google::Ads::AdManager::V1::EnvironmentTypeEnum::EnvironmentType VIDEO_PLAYER}.
        class AdUnitSize
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The summary of a parent AdUnit.
        # @!attribute [r] parent_ad_unit
        #   @return [::String]
        #     Output only. The parent of the current AdUnit
        #     Format: `networks/{network_code}/adUnits/{ad_unit_id}`
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The display name of the parent AdUnit.
        # @!attribute [r] ad_unit_code
        #   @return [::String]
        #     Output only. A string used to uniquely identify the ad unit for the
        #     purposes of serving the ad.
        class AdUnitParent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Frequency cap using a label.
        # @!attribute [rw] label
        #   @return [::String]
        #     Required. The label to used for frequency capping.
        #     Format: "networks/\\{network_code}/labels/\\{label_id}"
        # @!attribute [rw] frequency_cap
        #   @return [::Google::Ads::AdManager::V1::FrequencyCap]
        #     The frequency cap.
        class LabelFrequencyCap
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
