# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Request object for `SearchAdReviewCenterAds` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of AdReviewCenterAds.
        #     Format: networks/\\{network_code}/webProperties/\\{web_property_code}
        #
        #     Since a network can only have a single web property of each
        #     `ExchangeSyndicationProduct`, you can use the
        #     `ExchangeSyndicationProduct` as an alias for the web property code:
        #
        #     `networks/{network_code}/webProperties/display`
        #
        #     `networks/{network_code}/webProperties/videoAndAudio`
        #
        #     `networks/{network_code}/webProperties/mobileApp`
        #
        #     `networks/{network_code}/webProperties/games`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of AdReviewCenterAds to return. The service
        #     may return fewer than this value. If unspecified, at most 50
        #     AdReviewCenterAds will be returned. The maximum value is 1000; values
        #     greater than 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The page token to fetch the next page of AdReviewCenterAds. This
        #     is the value returned from a previous Search request, or empty.
        # @!attribute [rw] status
        #   @return [::Google::Ads::AdManager::V1::AdReviewCenterAdStatusEnum::AdReviewCenterAdStatus]
        #     Optional. Only return ads with the given status.
        # @!attribute [rw] ad_review_center_ad_id
        #   @return [::Array<::String>]
        #     Optional. Only return ads with the given AdReviewCenterAd IDs. If provided,
        #     no other filter can be set (other than page size and page token).
        # @!attribute [rw] date_time_range
        #   @return [::Google::Type::Interval]
        #     Optional. If provided, only return ads that served within the given date
        #     range (inclusive). The  date range must be within the last 30 days. If not
        #     provided, the date range will be the last 30 days.
        # @!attribute [rw] search_text
        #   @return [::Array<::String>]
        #     Optional. If provided, restrict the search to AdReviewCenterAds associated
        #     with the text (including any text on the ad or in the destination URL). If
        #     more than one value is provided, the search will combine them in a logical
        #     AND. For example, ['car', 'blue'] will match ads that contain both "car"
        #     and "blue", but not an ad that only contains "car".
        # @!attribute [rw] buyer_account_id
        #   @return [::Array<::Integer>]
        #     Optional. If provided, restrict the search to creatives belonging to one of
        #     the given Adx buyer account IDs. Only applicable to RTB creatives. Adx
        #     buyer account IDs can be found via the ProgrammaticBuyerService.
        class SearchAdReviewCenterAdsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `SearchAdReviewCenterAds` method.
        # @!attribute [rw] ad_review_center_ads
        #   @return [::Array<::Google::Ads::AdManager::V1::AdReviewCenterAd>]
        #     The AdReviewCenterAds that match the search request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class SearchAdReviewCenterAdsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `BatchAllowAdReviewCenterAds` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of AdReviewCenterAds.
        #     Format: networks/\\{network_code}/webProperties/\\{web_property_code}
        #
        #     Since a network can only have a single web property of each
        #     `ExchangeSyndicationProduct`, you can use the
        #     `ExchangeSyndicationProduct` as an alias for the web property code:
        #
        #     `networks/{network_code}/webProperties/display`
        #
        #     `networks/{network_code}/webProperties/videoAndAudio`
        #
        #     `networks/{network_code}/webProperties/mobileApp`
        #
        #     `networks/{network_code}/webProperties/games`
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. The resource names of the `AdReviewCenterAd`s to allow.
        #     Format:
        #     `networks/{network_code}/webProperties/{web_property_code}/adReviewCenterAds/{ad_review_center_ad_id}`
        class BatchAllowAdReviewCenterAdsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchAllowAdReviewCenterAds` method.
        class BatchAllowAdReviewCenterAdsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `BatchBlockAdReviewCenterAds` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of AdReviewCenterAds.
        #     Format: networks/\\{network_code}/webProperties/\\{web_property_code}
        #
        #     Since a network can only have a single web property of each
        #     `ExchangeSyndicationProduct`, you can use the
        #     `ExchangeSyndicationProduct` as an alias for the web property code:
        #
        #     `networks/{network_code}/webProperties/display`
        #
        #     `networks/{network_code}/webProperties/videoAndAudio`
        #
        #     `networks/{network_code}/webProperties/mobileApp`
        #
        #     `networks/{network_code}/webProperties/games`
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. The resource names of the `AdReviewCenterAd`s to block.
        #     Format:
        #     `networks/{network_code}/webProperties/{web_property_code}/adReviewCenterAds/{ad_review_center_ad_id}`
        class BatchBlockAdReviewCenterAdsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `BatchBlockAdReviewCenterAds` method.
        class BatchBlockAdReviewCenterAdsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata object for `BatchAllowAdReviewCenterAds` and
        # `BatchBlockAdReviewCenterAds` methods.
        # @!attribute [rw] failed_requests
        #   @return [::Google::Protobuf::Map{::Integer => ::Google::Rpc::Status}]
        #     The status of each failed request, keyed by the index of the corresponding
        #     request in the batch request.
        class BatchAdReviewCenterAdsOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::Integer]
          # @!attribute [rw] value
          #   @return [::Google::Rpc::Status]
          class FailedRequestsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
