# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # Request object for `GetAdBreak` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the AdBreak using the asset key or custom
        #     asset key.
        #
        #     Format:
        #     `networks/{network_code}/liveStreamEventsByAssetKey/{asset_key}/adBreaks/{ad_break_id}`
        #     `networks/{network_code}/liveStreamEventsByCustomAssetKey/{custom_asset_key}/adBreaks/{ad_break_id}`
        class GetAdBreakRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `ListAdBreaks` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of AdBreaks.
        #
        #     Formats:
        #     `networks/{network_code}/liveStreamEventsByAssetKey/{asset_key}`
        #     `networks/{network_code}/liveStreamEventsByCustomAssetKey/{custom_asset_key}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of `AdBreaks` to return. The service might
        #     return fewer than this value. If unspecified, at most 10 ad breaks are
        #     returned. The maximum value is `100`. Values above `100` are coerced to
        #     `100`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListAdBreaks` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListAdBreaks` must match
        #     the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Expression to filter the response.
        #     See syntax details at
        #     https://developers.google.com/ad-manager/api/beta/filters
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Expression to specify sorting order.
        #     See syntax details at
        #     https://developers.google.com/ad-manager/api/beta/filters#order
        # @!attribute [rw] skip
        #   @return [::Integer]
        #     Optional. Number of individual resources to skip while paginating.
        class ListAdBreaksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response object for `ListAdBreaksRequest` containing matching `AdBreak`
        # objects.
        # @!attribute [rw] ad_breaks
        #   @return [::Array<::Google::Ads::AdManager::V1::AdBreak>]
        #     The `AdBreak` objects from the specified network.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages. This field expires
        #     after five minutes.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     Total number of `AdBreak` objects.
        #     If a filter was included in the request, this reflects the total number
        #     after the filtering is applied.
        #
        #     `total_size` won't be calculated in the response unless it has been
        #     included in a response field mask. The response field mask can be provided
        #     to the method by using the URL parameter `$fields` or `fields`, or by using
        #     the HTTP/gRPC header `X-Goog-FieldMask`.
        #
        #     For more information, see
        #     https://developers.google.com/ad-manager/api/beta/field-masks
        class ListAdBreaksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `CreateAdBreak` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this `AdBreak` will be created
        #     identified by an asset key or custom asset key.
        #
        #     Formats:
        #     `networks/{network_code}/liveStreamEventsByAssetKey/{asset_key}`
        #     `networks/{network_code}/liveStreamEventsByCustomAssetKey/{custom_asset_key}`
        # @!attribute [rw] ad_break
        #   @return [::Google::Ads::AdManager::V1::AdBreak]
        #     Required. The `AdBreak` to create.
        class CreateAdBreakRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `UpdateAdBreak` method.
        # @!attribute [rw] ad_break
        #   @return [::Google::Ads::AdManager::V1::AdBreak]
        #     Required. The `AdBreak` to update.
        #
        #     The `AdBreak`'s `name` is used to identify the `AdBreak` to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateAdBreakRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request object for `DeleteAdBreak` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the ad break to delete.
        #
        #     Format:
        #     `networks/{network_code}/liveStreamEventsByAssetKey/{asset_key}/adBreaks/{ad_break}`
        class DeleteAdBreakRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
