# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        # The `AdBreak` resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the `AdBreak`.
        #     This field uses the `LiveStreamEvent` resource's asset key in the
        #     URI, even if the ad break was created, updated, or queried using the custom
        #     asset key.
        #
        #     Format:
        #     `networks/{network_code}/liveStreamEventsByAssetKey/{asset_key}/adBreaks/{ad_break_id}`
        # @!attribute [rw] ad_break_id
        #   @return [::String]
        #     Optional. Immutable. `AdBreak` ID.
        #     Must consist only of lowercase letters, digits, and hyphens. Ad break IDs
        #     have a maximum length of 63 characters.
        #     If not set, an ad break ID is generated as a UUID string.
        # @!attribute [rw] asset_key
        #   @return [::String]
        #     Optional. Immutable. The asset key of the `LiveStreamEvent` that the ad
        #     break belongs to. Either an asset key or a custom asset key must be
        #     provided for creation.
        # @!attribute [rw] custom_asset_key
        #   @return [::String]
        #     Optional. Immutable. The custom asset key of the `LiveStreamEvent` that the
        #     ad break belongs to. Either an asset key or a custom asset key must be
        #     provided for creation.
        # @!attribute [rw] expected_start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. The expected start time of the ad break.
        #     When set, the scheduled ad break will be decisioned shortly before the
        #     expected start time.
        #     If this field is not set, ad decisioning begins immediately.
        #     An ad break can be created up to six hours before the expected start time.
        # @!attribute [rw] duration
        #   @return [::Google::Protobuf::Duration]
        #     Required. The duration of the `AdBreak`.
        #     An expected duration in seconds with up to nine fractional digits, ending
        #     with `s`, for example, `3.5s`. This value will be updated to match the
        #     actual duration from the manifest or pod request after the ad break's state
        #     is
        #     {::Google::Ads::AdManager::V1::AdBreakStateEnum::AdBreakState::COMPLETE `COMPLETE`}.
        # @!attribute [r] break_state
        #   @return [::Google::Ads::AdManager::V1::AdBreakStateEnum::AdBreakState]
        #     Output only. The state of the `AdBreak`.
        # @!attribute [r] break_sequence
        #   @return [::Integer]
        #     Output only. The sequence id of the `AdBreak`.
        #     The unique sequence number of the created ad break. This value is only set
        #     after the `AdBreak` starts decisioning indicated by the ad break state's
        #     being
        #     {::Google::Ads::AdManager::V1::AdBreakStateEnum::AdBreakState::DECISIONED `DECISIONED`}
        #     .
        # @!attribute [rw] pod_template_name
        #   @return [::String]
        #     Optional. The pod template name of the `AdBreak`.
        #     This field is the required unique name across all pod templates in the
        #     network, not the display name.
        # @!attribute [rw] custom_params
        #   @return [::String]
        #     Optional. The key-value pairs to be included on the ad requests for this
        #     `AdBreak`. Key-value pairs to include on ad requests for this break for
        #     custom criteria targeting in Google Ad Manager, separated by `=` and joined
        #     by
        #     `&`.
        #
        #     Format:"key1=value&key2=value"
        # @!attribute [rw] scte_35_cue_out
        #   @return [::String]
        #     Optional. The Base64-encoded SCTE-35 command associated with the `AdBreak`.
        #     This field can include the `splice_insert()` or `time_signal()` command.
        #
        #     **Examples**
        #
        #     * `time_signal()`
        #       ```
        #       /DA0AAAAAAAA///wBQb+cr0AUAAeAhxDVUVJSAAAjn/PAAGlmbAICAAAAAAsoKGKNAIAmsnRfg==
        #       ```
        #     * `splice_insert()`
        #       ```
        #       /DAvAAAAAAAA///wFAVIAACPf+/+c2nALv4AUsz1AAAAAAAKAAhDVUVJAAABNWLbowo=
        #       ```
        class AdBreak
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
