# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/ads/admanager/v1/ad_break_service.proto for package 'Google.Ads.AdManager.V1'
# Original file comments:
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/ads/admanager/v1/ad_break_service_pb'

module Google
  module Ads
    module AdManager
      module V1
        module AdBreakService
          # Provides methods for handling `AdBreak` objects.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.ads.admanager.v1.AdBreakService'

            # API to retrieve an `AdBreak` object.
            #
            # Query an ad break by its resource name or custom asset key. Check the
            # resource's `breakState` field to determine its state.
            rpc :GetAdBreak, ::Google::Ads::AdManager::V1::GetAdBreakRequest, ::Google::Ads::AdManager::V1::AdBreak
            # API to retrieve a list of `AdBreak` objects.
            #
            # By default, when no `orderBy` query parameter is specified, ad breaks are
            # ordered reverse chronologically. However, ad breaks with a 'breakState' of
            # 'SCHEDULED' or 'DECISIONED' are prioritized and appear first.
            rpc :ListAdBreaks, ::Google::Ads::AdManager::V1::ListAdBreaksRequest, ::Google::Ads::AdManager::V1::ListAdBreaksResponse
            # API to create an `AdBreak` object.
            #
            # Informs DAI of an upcoming ad break for a live stream event, with an
            # optional expected start time. DAI will begin decisioning ads for the break
            # shortly before the expected start time, if provided. Each live stream
            # event can only have one incomplete ad break at any given time. The next ad
            # break can be scheduled after the previous ad break has started serving,
            # indicated by its state being
            # [`COMPLETE`][google.ads.admanager.v1.AdBreakStateEnum.AdBreakState.COMPLETE],
            # or it has been deleted.
            #
            # This method cannot be used if the `LiveStreamEvent` has
            # [prefetching ad breaks
            # enabled](https://developers.google.com/ad-manager/api/reference/latest/LiveStreamEventService.LiveStreamEvent#prefetchenabled)
            # or the event is not active. If a `LiveStreamEvent` is deactivated after
            # creating an ad break and before the ad break is complete, the ad break
            # is discarded.
            #
            # An ad break's state is complete when the following occurs:
            #  - Full service DAI: after a matching ad break shows in the
            #  `LiveStreamEvent` manifest only when the ad break has started decisioning.
            #  - Pod Serving: after the ad break is requested using the ad break ID or
            #  break sequence.
            rpc :CreateAdBreak, ::Google::Ads::AdManager::V1::CreateAdBreakRequest, ::Google::Ads::AdManager::V1::AdBreak
            # API to update an `AdBreak` object.
            #
            # Modify an ad break when its state is
            # [`SCHEDULED`][google.ads.admanager.v1.AdBreakStateEnum.AdBreakState.SCHEDULED].
            rpc :UpdateAdBreak, ::Google::Ads::AdManager::V1::UpdateAdBreakRequest, ::Google::Ads::AdManager::V1::AdBreak
            # API to delete an `AdBreak` object.
            #
            # Deletes and cancels an incomplete ad break, mitigating the need to wait
            # for the current break to serve before recreating an ad break. You can
            # delete an ad break that has not started serving or seen in manifests,
            # indicated by its state being
            # [`SCHEDULED`][google.ads.admanager.v1.AdBreakStateEnum.AdBreakState.SCHEDULED]
            # or
            # [`DECISIONED`][google.ads.admanager.v1.AdBreakStateEnum.AdBreakState.DECISIONED].
            rpc :DeleteAdBreak, ::Google::Ads::AdManager::V1::DeleteAdBreakRequest, ::Google::Protobuf::Empty
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
