# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        module TaxonomyCategoryService
          # Path helper methods for the TaxonomyCategoryService API.
          module Paths
            ##
            # Create a fully-qualified Network resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}`
            #
            # @param network_code [String]
            #
            # @return [::String]
            def network_path network_code:
              "networks/#{network_code}"
            end

            ##
            # Create a fully-qualified TaxonomyCategory resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/taxonomyCategories/{taxonomy_category}`
            #
            # @param network_code [String]
            # @param taxonomy_category [String]
            #
            # @return [::String]
            def taxonomy_category_path network_code:, taxonomy_category:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/taxonomyCategories/#{taxonomy_category}"
            end

            extend self
          end
        end
      end
    end
  end
end
