# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        module PrivateAuctionDealService
          # Path helper methods for the PrivateAuctionDealService API.
          module Paths
            ##
            # Create a fully-qualified AdUnit resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/adUnits/{ad_unit}`
            #
            # @param network_code [String]
            # @param ad_unit [String]
            #
            # @return [::String]
            def ad_unit_path network_code:, ad_unit:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/adUnits/#{ad_unit}"
            end

            ##
            # Create a fully-qualified Application resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/applications/{application}`
            #
            # @param network_code [String]
            # @param application [String]
            #
            # @return [::String]
            def application_path network_code:, application:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/applications/#{application}"
            end

            ##
            # Create a fully-qualified AudienceSegment resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/audienceSegments/{audience_segment}`
            #
            # @param network_code [String]
            # @param audience_segment [String]
            #
            # @return [::String]
            def audience_segment_path network_code:, audience_segment:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/audienceSegments/#{audience_segment}"
            end

            ##
            # Create a fully-qualified BandwidthGroup resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/bandwidthGroups/{bandwidth_group}`
            #
            # @param network_code [String]
            # @param bandwidth_group [String]
            #
            # @return [::String]
            def bandwidth_group_path network_code:, bandwidth_group:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/bandwidthGroups/#{bandwidth_group}"
            end

            ##
            # Create a fully-qualified Browser resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/browsers/{browser}`
            #
            # @param network_code [String]
            # @param browser [String]
            #
            # @return [::String]
            def browser_path network_code:, browser:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/browsers/#{browser}"
            end

            ##
            # Create a fully-qualified BrowserLanguage resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/browserLanguages/{browser_language}`
            #
            # @param network_code [String]
            # @param browser_language [String]
            #
            # @return [::String]
            def browser_language_path network_code:, browser_language:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/browserLanguages/#{browser_language}"
            end

            ##
            # Create a fully-qualified CmsMetadataValue resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/cmsMetadataValues/{cms_metadata_value}`
            #
            # @param network_code [String]
            # @param cms_metadata_value [String]
            #
            # @return [::String]
            def cms_metadata_value_path network_code:, cms_metadata_value:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/cmsMetadataValues/#{cms_metadata_value}"
            end

            ##
            # Create a fully-qualified Content resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/content/{content}`
            #
            # @param network_code [String]
            # @param content [String]
            #
            # @return [::String]
            def content_path network_code:, content:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/content/#{content}"
            end

            ##
            # Create a fully-qualified ContentBundle resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/contentBundles/{content_bundle}`
            #
            # @param network_code [String]
            # @param content_bundle [String]
            #
            # @return [::String]
            def content_bundle_path network_code:, content_bundle:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/contentBundles/#{content_bundle}"
            end

            ##
            # Create a fully-qualified CustomTargetingKey resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/customTargetingKeys/{custom_targeting_key}`
            #
            # @param network_code [String]
            # @param custom_targeting_key [String]
            #
            # @return [::String]
            def custom_targeting_key_path network_code:, custom_targeting_key:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/customTargetingKeys/#{custom_targeting_key}"
            end

            ##
            # Create a fully-qualified CustomTargetingValue resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/customTargetingValues/{custom_targeting_value}`
            #
            # @param network_code [String]
            # @param custom_targeting_value [String]
            #
            # @return [::String]
            def custom_targeting_value_path network_code:, custom_targeting_value:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/customTargetingValues/#{custom_targeting_value}"
            end

            ##
            # Create a fully-qualified DeviceCapability resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/deviceCapabilities/{device_capability}`
            #
            # @param network_code [String]
            # @param device_capability [String]
            #
            # @return [::String]
            def device_capability_path network_code:, device_capability:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/deviceCapabilities/#{device_capability}"
            end

            ##
            # Create a fully-qualified DeviceCategory resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/deviceCategories/{device_category}`
            #
            # @param network_code [String]
            # @param device_category [String]
            #
            # @return [::String]
            def device_category_path network_code:, device_category:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/deviceCategories/#{device_category}"
            end

            ##
            # Create a fully-qualified DeviceManufacturer resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/deviceManufacturers/{device_manufacturer}`
            #
            # @param network_code [String]
            # @param device_manufacturer [String]
            #
            # @return [::String]
            def device_manufacturer_path network_code:, device_manufacturer:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/deviceManufacturers/#{device_manufacturer}"
            end

            ##
            # Create a fully-qualified GeoTarget resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/geoTargets/{geo_target}`
            #
            # @param network_code [String]
            # @param geo_target [String]
            #
            # @return [::String]
            def geo_target_path network_code:, geo_target:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/geoTargets/#{geo_target}"
            end

            ##
            # Create a fully-qualified MobileCarrier resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/mobileCarriers/{mobile_carrier}`
            #
            # @param network_code [String]
            # @param mobile_carrier [String]
            #
            # @return [::String]
            def mobile_carrier_path network_code:, mobile_carrier:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/mobileCarriers/#{mobile_carrier}"
            end

            ##
            # Create a fully-qualified MobileDevice resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/mobileDevices/{mobile_device}`
            #
            # @param network_code [String]
            # @param mobile_device [String]
            #
            # @return [::String]
            def mobile_device_path network_code:, mobile_device:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/mobileDevices/#{mobile_device}"
            end

            ##
            # Create a fully-qualified MobileDeviceSubmodel resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/mobileDeviceSubmodels/{mobile_device_submodel}`
            #
            # @param network_code [String]
            # @param mobile_device_submodel [String]
            #
            # @return [::String]
            def mobile_device_submodel_path network_code:, mobile_device_submodel:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/mobileDeviceSubmodels/#{mobile_device_submodel}"
            end

            ##
            # Create a fully-qualified Network resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}`
            #
            # @param network_code [String]
            #
            # @return [::String]
            def network_path network_code:
              "networks/#{network_code}"
            end

            ##
            # Create a fully-qualified OperatingSystem resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/operatingSystems/{operating_system}`
            #
            # @param network_code [String]
            # @param operating_system [String]
            #
            # @return [::String]
            def operating_system_path network_code:, operating_system:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/operatingSystems/#{operating_system}"
            end

            ##
            # Create a fully-qualified OperatingSystemVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/operatingSystemVersions/{operating_system_version}`
            #
            # @param network_code [String]
            # @param operating_system_version [String]
            #
            # @return [::String]
            def operating_system_version_path network_code:, operating_system_version:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/operatingSystemVersions/#{operating_system_version}"
            end

            ##
            # Create a fully-qualified Placement resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/placements/{placement}`
            #
            # @param network_code [String]
            # @param placement [String]
            #
            # @return [::String]
            def placement_path network_code:, placement:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/placements/#{placement}"
            end

            ##
            # Create a fully-qualified PrivateAuctionDeal resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/privateAuctionDeals/{private_auction_deal}`
            #
            # @param network_code [String]
            # @param private_auction_deal [String]
            #
            # @return [::String]
            def private_auction_deal_path network_code:, private_auction_deal:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/privateAuctionDeals/#{private_auction_deal}"
            end

            extend self
          end
        end
      end
    end
  end
end
