# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/ads/admanager/v1/contact_service_pb"
require "google/ads/ad_manager/v1/contact_service/rest/service_stub"

module Google
  module Ads
    module AdManager
      module V1
        module ContactService
          module Rest
            ##
            # REST client for the ContactService service.
            #
            # Provides methods for handling `Contact` objects.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "admanager.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :contact_service_stub

              ##
              # Configure the ContactService Client class.
              #
              # See {::Google::Ads::AdManager::V1::ContactService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ContactService clients
              #   ::Google::Ads::AdManager::V1::ContactService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Ads", "AdManager", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ContactService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Ads::AdManager::V1::ContactService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @contact_service_stub.universe_domain
              end

              ##
              # Create a new ContactService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Ads::AdManager::V1::ContactService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Ads::AdManager::V1::ContactService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ContactService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @contact_service_stub = ::Google::Ads::AdManager::V1::ContactService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @contact_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @contact_service_stub.logger
              end

              # Service calls

              ##
              # API to retrieve a `Contact` object.
              #
              # @overload get_contact(request, options = nil)
              #   Pass arguments to `get_contact` via a request object, either of type
              #   {::Google::Ads::AdManager::V1::GetContactRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::AdManager::V1::GetContactRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_contact(name: nil)
              #   Pass arguments to `get_contact` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the Contact.
              #     Format: `networks/{network_code}/contacts/{contact_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Ads::AdManager::V1::Contact]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Ads::AdManager::V1::Contact]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/ads/ad_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::AdManager::V1::ContactService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::AdManager::V1::GetContactRequest.new
              #
              #   # Call the get_contact method.
              #   result = client.get_contact request
              #
              #   # The returned object is of type Google::Ads::AdManager::V1::Contact.
              #   p result
              #
              def get_contact request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::AdManager::V1::GetContactRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_contact.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::AdManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_contact.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_contact.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_service_stub.get_contact request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # API to retrieve a list of `Contact` objects.
              #
              # @overload list_contacts(request, options = nil)
              #   Pass arguments to `list_contacts` via a request object, either of type
              #   {::Google::Ads::AdManager::V1::ListContactsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::AdManager::V1::ListContactsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_contacts(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, skip: nil)
              #   Pass arguments to `list_contacts` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of Contacts.
              #     Format: `networks/{network_code}`
              #   @param page_size [::Integer]
              #     Optional. The maximum number of `Contacts` to return. The service may
              #     return fewer than this value. If unspecified, at most 50 `Contacts` will be
              #     returned. The maximum value is 1000; values greater than 1000 will be
              #     coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListContacts` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListContacts` must match
              #     the call that provided the page token.
              #   @param filter [::String]
              #     Optional. Expression to filter the response.
              #     See syntax details at
              #     https://developers.google.com/ad-manager/api/beta/filters
              #   @param order_by [::String]
              #     Optional. Expression to specify sorting order.
              #     See syntax details at
              #     https://developers.google.com/ad-manager/api/beta/filters#order
              #   @param skip [::Integer]
              #     Optional. Number of individual resources to skip while paginating.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Ads::AdManager::V1::Contact>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Ads::AdManager::V1::Contact>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/ads/ad_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::AdManager::V1::ContactService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::AdManager::V1::ListContactsRequest.new
              #
              #   # Call the list_contacts method.
              #   result = client.list_contacts request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Ads::AdManager::V1::Contact.
              #     p item
              #   end
              #
              def list_contacts request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::AdManager::V1::ListContactsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_contacts.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::AdManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_contacts.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_contacts.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_service_stub.list_contacts request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @contact_service_stub, :list_contacts, "contacts", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # API to create a `Contact` object.
              #
              # @overload create_contact(request, options = nil)
              #   Pass arguments to `create_contact` via a request object, either of type
              #   {::Google::Ads::AdManager::V1::CreateContactRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::AdManager::V1::CreateContactRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_contact(parent: nil, contact: nil)
              #   Pass arguments to `create_contact` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource where this `Contact` will be created.
              #     Format: `networks/{network_code}`
              #   @param contact [::Google::Ads::AdManager::V1::Contact, ::Hash]
              #     Required. The `Contact` to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Ads::AdManager::V1::Contact]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Ads::AdManager::V1::Contact]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/ads/ad_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::AdManager::V1::ContactService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::AdManager::V1::CreateContactRequest.new
              #
              #   # Call the create_contact method.
              #   result = client.create_contact request
              #
              #   # The returned object is of type Google::Ads::AdManager::V1::Contact.
              #   p result
              #
              def create_contact request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::AdManager::V1::CreateContactRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_contact.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::AdManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_contact.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_contact.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_service_stub.create_contact request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # API to batch create `Contact` objects.
              #
              # @overload batch_create_contacts(request, options = nil)
              #   Pass arguments to `batch_create_contacts` via a request object, either of type
              #   {::Google::Ads::AdManager::V1::BatchCreateContactsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::AdManager::V1::BatchCreateContactsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_create_contacts(parent: nil, requests: nil)
              #   Pass arguments to `batch_create_contacts` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource where `Contacts` will be created.
              #     Format: `networks/{network_code}`
              #     The parent field in the CreateContactRequest must match this
              #     field.
              #   @param requests [::Array<::Google::Ads::AdManager::V1::CreateContactRequest, ::Hash>]
              #     Required. The `Contact` objects to create.
              #     A maximum of 100 objects can be created in a batch.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Ads::AdManager::V1::BatchCreateContactsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Ads::AdManager::V1::BatchCreateContactsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/ads/ad_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::AdManager::V1::ContactService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::AdManager::V1::BatchCreateContactsRequest.new
              #
              #   # Call the batch_create_contacts method.
              #   result = client.batch_create_contacts request
              #
              #   # The returned object is of type Google::Ads::AdManager::V1::BatchCreateContactsResponse.
              #   p result
              #
              def batch_create_contacts request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::AdManager::V1::BatchCreateContactsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_create_contacts.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::AdManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_create_contacts.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_create_contacts.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_service_stub.batch_create_contacts request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # API to update a `Contact` object.
              #
              # @overload update_contact(request, options = nil)
              #   Pass arguments to `update_contact` via a request object, either of type
              #   {::Google::Ads::AdManager::V1::UpdateContactRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::AdManager::V1::UpdateContactRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_contact(contact: nil, update_mask: nil)
              #   Pass arguments to `update_contact` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param contact [::Google::Ads::AdManager::V1::Contact, ::Hash]
              #     Required. The `Contact` to update.
              #
              #     The `Contact`'s `name` is used to identify the `Contact` to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Ads::AdManager::V1::Contact]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Ads::AdManager::V1::Contact]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/ads/ad_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::AdManager::V1::ContactService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::AdManager::V1::UpdateContactRequest.new
              #
              #   # Call the update_contact method.
              #   result = client.update_contact request
              #
              #   # The returned object is of type Google::Ads::AdManager::V1::Contact.
              #   p result
              #
              def update_contact request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::AdManager::V1::UpdateContactRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_contact.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::AdManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_contact.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_contact.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_service_stub.update_contact request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # API to batch update `Contact` objects.
              #
              # @overload batch_update_contacts(request, options = nil)
              #   Pass arguments to `batch_update_contacts` via a request object, either of type
              #   {::Google::Ads::AdManager::V1::BatchUpdateContactsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Ads::AdManager::V1::BatchUpdateContactsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_update_contacts(parent: nil, requests: nil)
              #   Pass arguments to `batch_update_contacts` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource where `Contacts` will be updated.
              #     Format: `networks/{network_code}`
              #     The parent field in the UpdateContactRequest must match this
              #     field.
              #   @param requests [::Array<::Google::Ads::AdManager::V1::UpdateContactRequest, ::Hash>]
              #     Required. The `Contact` objects to update.
              #     A maximum of 100 objects can be updated in a batch.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Ads::AdManager::V1::BatchUpdateContactsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Ads::AdManager::V1::BatchUpdateContactsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/ads/ad_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Ads::AdManager::V1::ContactService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Ads::AdManager::V1::BatchUpdateContactsRequest.new
              #
              #   # Call the batch_update_contacts method.
              #   result = client.batch_update_contacts request
              #
              #   # The returned object is of type Google::Ads::AdManager::V1::BatchUpdateContactsResponse.
              #   p result
              #
              def batch_update_contacts request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Ads::AdManager::V1::BatchUpdateContactsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_update_contacts.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Ads::AdManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_update_contacts.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_update_contacts.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_service_stub.batch_update_contacts request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ContactService REST API.
              #
              # This class represents the configuration for ContactService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Ads::AdManager::V1::ContactService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # get_contact to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Ads::AdManager::V1::ContactService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_contact.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Ads::AdManager::V1::ContactService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_contact.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "admanager.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the ContactService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `get_contact`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_contact
                  ##
                  # RPC-specific configuration for `list_contacts`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_contacts
                  ##
                  # RPC-specific configuration for `create_contact`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_contact
                  ##
                  # RPC-specific configuration for `batch_create_contacts`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_create_contacts
                  ##
                  # RPC-specific configuration for `update_contact`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_contact
                  ##
                  # RPC-specific configuration for `batch_update_contacts`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_update_contacts

                  # @private
                  def initialize parent_rpcs = nil
                    get_contact_config = parent_rpcs.get_contact if parent_rpcs.respond_to? :get_contact
                    @get_contact = ::Gapic::Config::Method.new get_contact_config
                    list_contacts_config = parent_rpcs.list_contacts if parent_rpcs.respond_to? :list_contacts
                    @list_contacts = ::Gapic::Config::Method.new list_contacts_config
                    create_contact_config = parent_rpcs.create_contact if parent_rpcs.respond_to? :create_contact
                    @create_contact = ::Gapic::Config::Method.new create_contact_config
                    batch_create_contacts_config = parent_rpcs.batch_create_contacts if parent_rpcs.respond_to? :batch_create_contacts
                    @batch_create_contacts = ::Gapic::Config::Method.new batch_create_contacts_config
                    update_contact_config = parent_rpcs.update_contact if parent_rpcs.respond_to? :update_contact
                    @update_contact = ::Gapic::Config::Method.new update_contact_config
                    batch_update_contacts_config = parent_rpcs.batch_update_contacts if parent_rpcs.respond_to? :batch_update_contacts
                    @batch_update_contacts = ::Gapic::Config::Method.new batch_update_contacts_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
