# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        module AdUnitService
          # Path helper methods for the AdUnitService API.
          module Paths
            ##
            # Create a fully-qualified AdUnit resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/adUnits/{ad_unit}`
            #
            # @param network_code [String]
            # @param ad_unit [String]
            #
            # @return [::String]
            def ad_unit_path network_code:, ad_unit:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/adUnits/#{ad_unit}"
            end

            ##
            # Create a fully-qualified Label resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/labels/{label}`
            #
            # @param network_code [String]
            # @param label [String]
            #
            # @return [::String]
            def label_path network_code:, label:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/labels/#{label}"
            end

            ##
            # Create a fully-qualified Network resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}`
            #
            # @param network_code [String]
            #
            # @return [::String]
            def network_path network_code:
              "networks/#{network_code}"
            end

            ##
            # Create a fully-qualified Team resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/teams/{team}`
            #
            # @param network_code [String]
            # @param team [String]
            #
            # @return [::String]
            def team_path network_code:, team:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/teams/#{team}"
            end

            extend self
          end
        end
      end
    end
  end
end
